package com.gingersoft.gsa.cloud.main.mvp.ui.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.gingersoft.gsa.cloud.common.core.table.TableManagerItem;
import com.gingersoft.gsa.cloud.common.utils.StringUtils;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionHeader;
import com.gingersoft.gsa.cloud.ui.view.TriangleLabelView;
import com.gingersoft.gsa.cloud.ui.view.qm.QDLoadingItemView;
import com.gingersoft.gsa.cloud.ui.view.section.QDSectionHeaderView;
import com.jess.arms.utils.DeviceUtils;
import com.qmuiteam.qmui.layout.QMUIRelativeLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.section.QMUIDefaultStickySectionAdapter;
import com.qmuiteam.qmui.widget.section.QMUISection;
import com.qmuiteam.qmui.widget.section.QMUIStickySectionAdapter;

import java.util.HashMap;

import butterknife.BindView;
import butterknife.ButterKnife;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-02-09
 * 修订历史：2020-02-09
 * 描述：
 */
public class OriginalKitcherPrjSectiontAdapter extends QMUIDefaultStickySectionAdapter<SectionHeader, TableManagerItem> {

    private Context context;

    @NonNull
    @Override
    protected QMUIStickySectionAdapter.ViewHolder onCreateSectionHeaderViewHolder(@NonNull ViewGroup viewGroup) {
        this.context = viewGroup.getContext();
        return new QMUIStickySectionAdapter.ViewHolder(new QDSectionHeaderView(viewGroup.getContext()));
    }

    @NonNull
    @Override
    protected ViewHolder onCreateSectionItemViewHolder(@NonNull ViewGroup viewGroup) {
        this.context = viewGroup.getContext();
        return new ViewHolder(View.inflate(viewGroup.getContext(), R.layout.manager_item_manage_table, null));
    }

    @NonNull
    @Override
    protected QMUIStickySectionAdapter.ViewHolder onCreateSectionLoadingViewHolder(@NonNull ViewGroup viewGroup) {
        return new QMUIStickySectionAdapter.ViewHolder(new QDLoadingItemView(viewGroup.getContext()));
    }

    @Override
    protected void onBindSectionHeader(QMUIStickySectionAdapter.ViewHolder holder, int position, QMUISection<SectionHeader, TableManagerItem> section) {
        super.onBindSectionHeader(holder, position, section);
        QDSectionHeaderView itemView = (QDSectionHeaderView) holder.itemView;
        itemView.render(section.getHeader(), section.isFold());
        itemView.getArrowView().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int pos = holder.isForStickyHeader ? position : holder.getAdapterPosition();
                toggleFold(pos, false);
            }
        });
    }

    @Override
    protected void onBindSectionItem(QMUIStickySectionAdapter.ViewHolder holder, int position, QMUISection<SectionHeader, TableManagerItem> section, int itemIndex) {
        super.onBindSectionItem(holder, position, section, itemIndex);
        ViewHolder viewHolder = (ViewHolder) holder;

        TableManagerItem tableItem = section.getItemAt(itemIndex);
    }


    public class ViewHolder extends QMUIStickySectionAdapter.ViewHolder {

        @BindView(R2.id.ll_container)
        QMUIRelativeLayout ll_container;
        @BindView(R2.id.rl_table)
        RelativeLayout rl_table;
        @BindView(R2.id.tv_table)
        TextView tv_table;
        @BindView(R2.id.tv_people)
        TextView tv_people;
        //        @BindView(R2.id.btn_showMain)
//        Button btn_showMain;
//        @BindView(R2.id.iv_vip)
//        ImageView iv_vip;
//        @BindView(R2.id.tv_scan_flag)
//        TextView tv_scan_flag;
        @BindView(R2.id.tv_service_fee)
        TextView tv_service_fee;
        @BindView(R2.id.cb_checked)
        CheckBox cb_checked;

        @BindView(R2.id.fl_add_table)
        FrameLayout fl_add_table;
        @BindView(R2.id.fl_table_type)
        FrameLayout fl_table_type;
        @BindView(R2.id.tlv_table_type)
        TriangleLabelView tlv_table_type;
        @BindView(R2.id.tv_type_labe)
        TextView tv_type_labe;


        public ViewHolder(View itemView) {
            super(itemView);
            ButterKnife.bind(this, itemView);
        }

        public TextView getTvName() {
            return tv_table;
        }

        public TextView getTvServiceFee() {
            return tv_service_fee;
        }

        public TableManagerItem getTableItem(int position) {
            TableManagerItem item = getSectionItem(position);
            return item;
        }

    }

}
