package com.gingersoft.gsa.cloud.common.utils.xlog;

import com.elvishew.xlog.printer.file.naming.FileNameGenerator;
import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.jess.arms.utils.DeviceUtils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2019-12-06
 * 修订历史：2019-12-06
 * 描述：
 */
public class DateFileNameGenerator implements FileNameGenerator {

    ThreadLocal<SimpleDateFormat> mLocalDateFormat = new ThreadLocal<SimpleDateFormat>() {

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        }
    };

    @Override
    public boolean isFileNameChangeable() {
        return true;
    }

    /**
     * Generate a file name which represent a specific date.
     */
    @Override
    public String generateFileName(int logLevel, long timestamp) {
        SimpleDateFormat sdf = mLocalDateFormat.get();
        sdf.setTimeZone(TimeZone.getDefault());
        String machineName = "test_machine";
        String fileName = machineName + "-" + DeviceUtils.getVersionName(GsaCloudApplication.getAppContext()) + "-" + sdf.format(new Date(timestamp));
        return fileName;
    }
}
