package com.gingersoft.gsa.cloud.ui.adapter.bean;

import android.text.InputFilter;
import android.text.TextWatcher;
import lombok.Data;
import me.yokeyword.fragmentation.ISupportFragment;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/25
 * Time: 14:15
 * Use: 多類型輸入
 */
@Data
public class MultiInputBean extends InfoMultiBean {

    private InputFilter[] inputFilters;
    private int inputType = -1;
    private int maxLength = 0;
    private TextWatcher textWatcher;

    /**
     * 是否可以編輯
     */
    private boolean isEdit = true;

    private MultiInputBean() {
    }

    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText) {
        super(itemType, showTitle, isRequired, hintText);
    }

    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText, InputFilter[] inputFilters) {
        super(itemType, showTitle, isRequired, hintText);
        this.inputFilters = inputFilters;
    }

    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText, int type) {
        super(itemType, showTitle, isRequired, hintText);
        this.inputType = type;
    }

    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText, String showValue) {
        super(itemType, showTitle, isRequired, hintText, showValue);
    }

    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText, InputFilter[] inputFilters, int type) {
        super(itemType, showTitle, isRequired, hintText);
        this.inputFilters = inputFilters;
        this.inputType = type;
    }

    public MultiInputBean(int itemType, String showTitle, boolean isRequired, String hintText, String showValue, Class<? extends ISupportFragment> supportFragment) {
        super(itemType, showTitle, isRequired, hintText, showValue);
        this.fragment = supportFragment;
    }
}
