package com.gingersoft.gsa.other_order_mode.model.viewModel

import androidx.lifecycle.MutableLiveData
import com.gingersoft.gsa.other_order_mode.data.DeliveryRepository
import com.gingersoft.gsa.other_order_mode.data.model.bean.DeliveryAddSuccessConfig
import com.gingersoft.gsa.other_order_mode.data.model.bean.DeliveryConfig
import com.gingersoft.gsa.other_order_mode.data.model.bean.MessageBean

class DeliveryViewModel(private val repository: DeliveryRepository) : BaseViewModel() {

    var otherInfo = MutableLiveData<DeliveryConfig>()

    fun queryDeliveryList(restaurantId: String) {
        launch({
            repository.queryDeliveryList(restaurantId).apply {
                otherInfo.postValue(this)
            }
        }, {
            otherInfo.value = null
        })
    }

    fun addDeliveryConfig(distributionFeeMin: String, distributionFeeMax: String,
                          distributionFee: String, deliveryCost: String,
                          distributionType: String, type: Int,
                          desc: String, restaurantId: Int,
                          createBy: Int, lackPrice: String, listenter: (DeliveryAddSuccessConfig?) -> Unit) {
        launch({
            repository.addDeliveryConfig(DeliveryConfig.Data.DeliveryInfo("", deliveryCost.toDouble(), desc,
                    distributionFee.toDouble(), distributionFeeMax.toDouble(), distributionFeeMin.toDouble(), distributionType,
                    0, "", "", restaurantId, "", "", lackPrice.toDouble(),
                    type, createBy)).apply {
                listenter.invoke(this)
                queryDeliveryList(restaurantId.toString())
            }
        }, {
            listenter.invoke(null)
        })
    }

    fun updateDeliveryConfig(distributionFeeMin: String, distributionFeeMax: String,
                             distributionFee: String, deliveryCost: String,
                             distributionType: String, type: Int,
                             desc: String, id: Int, restaurantId: Int,
                             createBy: Int, lackPrice: String, deletes: Int, listenter: (MessageBean?) -> Unit) {
        launch({
            repository.updateDelivery(distributionFeeMin, distributionFeeMax, distributionFee, deliveryCost,
                    distributionType, type.toString(), desc, id.toString(), createBy.toString(), deletes, lackPrice).apply {
                listenter.invoke(this)
                queryDeliveryList(restaurantId.toString())
            }
        }, {
            listenter.invoke(null)
        })
    }
}
