package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.base.adapter.print.KitChenPrintFoodAdapter;
import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.common.bean.OrderDetail;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.MyOrderManage;
import com.gingersoft.gsa.cloud.base.common.bean.mealManage.OpenTableManage;
import com.gingersoft.gsa.cloud.base.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.joe.print.R;
import com.joe.print.mvp.model.bean.PrjBean;
import com.joe.print.mvp.ui.adapter.KitChenPrjPrintFoodAdapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import static com.gingersoft.gsa.cloud.base.common.bean.OrderDetail.DISCOUNT_TYPE;
import static com.gingersoft.gsa.cloud.base.common.bean.OrderDetail.FOOD_TYPE;
import static com.gingersoft.gsa.cloud.base.common.bean.OrderDetail.MODIFIER_TYPE;

/**
 * 廚房單打印
 */
public class PrintPrjKitchen extends PrinterRoot {

    private static Map<String, List<PrjBean.DataBean.Bean>> prjMap;

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        //通過打印位置生成多張用於打印的bitmap
        for (Map.Entry<String, List<PrjBean.DataBean.Bean>> entry : getPrjMap().entrySet()) {
            String key = entry.getKey();
            List<Bitmap> bitmaps = new ArrayList<>();

            Bitmap bitmap = getKitChenPrintBitmap(mContext, key, entry.getValue());
            //不帶*號，所有同樣廚房位置的食品都在一張紙上
            bitmaps.add(bitmap);

            bitmapMaps.put(key, bitmaps);
        }
        prjMap.clear();
        return bitmapMaps;
    }

    @Override
    public int getPrintCount(Context context) {
        return 1;
    }

    /**
     * 獲取"廚房單"圖片
     *
     * @param context
     * @return
     */
    private Bitmap getKitChenPrintBitmap(Context context, String key, List<PrjBean.DataBean.Bean> data) {
        if (data == null || data.size() <= 0) {
            return null;
        }
        for (PrjBean.DataBean.Bean bean : data) {
            if (bean.getParentId() == 0) {
                //沒有父級id，則是第一級食品
                bean.setItemType(1);
            }
            //如果父級id不為0，是細項
            if (bean.getParentId() != 0) {
                bean.setItemType(2);//先設置為細項，再通過下面的遍歷確定是否是第三級細項
                //循環遍歷查找父級食品
                for (PrjBean.DataBean.Bean itembean : data) {
                    if (bean.getParentId() == itembean.getOrderDetailsId()) {
                        //如果父級是細項，則當前食品就是二級細項
                        bean.setItemType(bean.getItemType() + 1);
                        break;
                    }
                }
            }
        }
        View view = LinearLayout.inflate(context, R.layout.print_kitchen, null);
        TextView tvTableNumber = view.findViewById(R.id.tv_kitchen_print_table_number);
        TextView tvOrderNumber = view.findViewById(R.id.tv_order_num);
        TextView tvOpeningTime = view.findViewById(R.id.tv_opening_time);
        TextView tvOrderTime = view.findViewById(R.id.tv_order_time);
        TextView tvKitChenLocation = view.findViewById(R.id.tv_kitchen_location);
        TextView tvPeople = view.findViewById(R.id.tv_people);
        TextView tvOperator = view.findViewById(R.id.tv_operator);
        RecyclerView rvFood = view.findViewById(R.id.rv_kitchen_food);
        TextView tvTableNumber2 = view.findViewById(R.id.tv_kitchen_print_table_number2);
        if (data.size() > 0 && data.get(0) != null) {
            KitChenPrjPrintFoodAdapter foodAdapter = new KitChenPrjPrintFoodAdapter(data);
            rvFood.setLayoutManager(new LinearLayoutManager(context));
            rvFood.setAdapter(foodAdapter);
            //廚房位置
            if (!TextUtil.isEmptyOrNullOrUndefined(key) && !key.equals("-1")) {
                tvKitChenLocation.setText(key);//.replace("*", "")
                tvKitChenLocation.setVisibility(View.VISIBLE);
            } else {
                tvKitChenLocation.setVisibility(View.GONE);
            }
        }
        tvTableNumber.setText(data.get(0).getTableName());
        tvTableNumber2.setText(data.get(0).getTableName());
        //人數
        tvPeople.setText(data.get(0).getPerson() + "");
        //訂單號
        tvOrderNumber.setText(data.get(0).getOrderNo());
        //開台時間
        tvOpeningTime.setText(TimeUtils.parseTimeRepeat(data.get(0).getOrderDetailsTime(), TimeUtils.DEFAULT_DATE_FORMAT));

//        if (OpenTableManage.getDefault().getTableBean() != null) {
//            //台號
//            tvTableNumber.setText(data.get(0).getTableName());
//            tvTableNumber2.setText(data.get(0).getTableName());
//            //人數
//            tvPeople.setText(data.get(0).getPerson() + "");
//            //訂單號
//            tvOrderNumber.setText(data.get(0).getOrderNo());
//            //開台時間
//            tvOpeningTime.setText(TimeUtils.parseTimeRepeat(data.get(0).getOrderDetailsTime(), TimeUtils.DEFAULT_DATE_FORMAT));
//        }
        //落單時間，為當前時間
        tvOrderTime.setText(TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT));
        //操作人員
        tvOperator.setText("");
        return viewToBitmap(context, view);
    }


    public static Map<String, List<PrjBean.DataBean.Bean>> getPrjMap() {
        if (prjMap == null) {
            prjMap = new HashMap<>();
        }
        return prjMap;
    }
}
