package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.TextView;

import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.R;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/28
 * Time: 11:45
 * Use: 編輯分類，一級分類適配器
 */
public class CategoryAdapter extends BaseQuickAdapter<OrderCategoryBean.FoodCategoryTrees, BaseViewHolder> {

    private int selectedIndex = 0;
    private Drawable selectedBg;
    private Drawable unSelectedBg;

    private int selectColor = -1;
    private int unSelectColor = -1;
    private boolean showDelete = false;

    public CategoryAdapter(@Nullable List<OrderCategoryBean.FoodCategoryTrees> data, Context context) {
        super(R.layout.item_category, data);
        addChildClickViewIds(R.id.iv_category_delete);
        selectedBg = ContextCompat.getDrawable(context, R.drawable.shape_left_radio_shadow);
        unSelectedBg = ContextCompat.getDrawable(context, R.color.trans);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, OrderCategoryBean.FoodCategoryTrees categoryBean) {
        TextView tvCategoryName = viewHolder.getView(R.id.tv_category_name);
        tvCategoryName.setText(categoryBean.getName());
        CardView view = viewHolder.getView(R.id.layout_category);
        if (viewHolder.getAdapterPosition() == selectedIndex) {
            if (selectedBg != null) {
                view.setBackground(selectedBg);
            }
            if (selectColor != -1) {
                tvCategoryName.setTextColor(selectColor);
            }
            tvCategoryName.setSelected(true);
        } else {
            tvCategoryName.setSelected(false);
            if (unSelectedBg != null) {
                view.setBackground(unSelectedBg);
            }
            if (unSelectColor != -1) {
                tvCategoryName.setTextColor(unSelectColor);
            }
        }
        viewHolder.setGone(R.id.iv_category_delete, !showDelete);
    }

    public void setShowDelete(boolean showDelete) {
        this.showDelete = showDelete;
        notifyDataSetChanged();
    }

    public CategoryAdapter setSelectedBg(Drawable selectedBg) {
        this.selectedBg = selectedBg;
        return this;
    }

    public CategoryAdapter setUnSelectedBg(Drawable unSelectedBg) {
        this.unSelectedBg = unSelectedBg;
        return this;
    }

    public CategoryAdapter setSelectColor(int selectColor) {
        this.selectColor = selectColor;
        return this;
    }

    public CategoryAdapter setUnSelectColor(int unSelectColor) {
        this.unSelectColor = unSelectColor;
        return this;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
        notifyDataSetChanged();
    }

    public int getSelectedIndex() {
        return selectedIndex;
    }
}
