package com.gingersoft.gsa.cloud.function;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Log;

import com.jess.arms.utils.DeviceUtils;

import java.util.HashSet;
import java.util.Set;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/8/11
 * 修订历史：2018/8/11
 * 描述：
 */
@Data
public class FunctionStyleUtils {

    private int ID;
    private String TableNumPadChar;
    private String PLUNumPadChar;
    private int FoodTypeFontSize = 12;
    private int FoodFontSize = 12;
    private String TableExt = "";
    private int BaseDpi = 480;
    private int BaseHeight = 1920;
    private int BaseWidth = 1080;
    private int ModFontSize = 14;
    private int BillListFontSize = 12;
    private int BillTotalFontSize = 12;
    private int FoodlListFontSize = 18;
    private int LayoutBillListHeight = 40;
    private int LayoutQtyHeight = 40;
    private int LayoutQuitHeight = 40;
    private int LayoutFoodTypeHeight = 100;
    private int FoodBtnHeight = 120;
    private int ModBtnHeight = 75;
    private int FoodTypeCol = 4;
    private int FoodTypeRow = 1;
    private int FoodCol = 4;
    private int ModCol = 5;
    private int DiscountCol = 5;
    private int TableDirection;
    private int RefreshTime = 1;
    private String ShowTableType = "1,2,3,5";
    private int servicecharge_tablemode;
    private int servicecharge_tablemode_setting;
    private int servicecharge_takeoutmode;
    private int servicecharge_deliverymode;
    private int servicecharge_pickupmode;
    private int tableType = 1;
    private boolean ServiceChargeIncludeItemDiscount;
    private boolean BillDiscountIncludeServiceCharge;
    private boolean Edit_Send;
    private int ItemDecimals;
    private int RoundingDecimal = 1;
    private int Rounding;
    private int SystemLanguage = 2;
    private int OpenTableVipFrontColor = 1;
    private int OpenTableVipBackColor = 2;
    private int nowLanguageIndex = 1;
    private String orderlanguage = "1,2,3";
    private boolean MemberLoginCover = true;
    private String LanageName = "中文,粵語,英文";
    private int DataLanguage = 2;
    private int AutoQuitTime = 600;
    private int ModFunctionBarHeight = 60;
    private int BottomBarHeight = 160;
    private int ReportFontSize = 15;
    private String ShopId = "";
    private boolean OrderFunction_Discount;
    private boolean OrderFunction_Transfer;
    private boolean OrderFunction_Print;
    private boolean MainFunction_Report;
    private int printerServerReadTime = 10;
    private boolean OrderFunction_VoidSentItem = false;
    private boolean OrderFunction_ItemDiscount = false;
    private boolean OrderFunction_ItemFoodMerge = false;
    private boolean OrderFunction_FoodTableMode = true;
    private boolean OrderFunction_FoodTemporay = true;
    private boolean Order_InputPax = true;
    private boolean Order_GetTables = true;
    private int OrderOperButtonHeight = 40;
    private int orderInfoHeight = 40;
    private int orderInfoFontSize = 16;
    private int OrderDataOperBtnWidth = 50;
    private int OrderDataOperBtnHeight = 50;
    private boolean BillTextScroll = true;
    private int TableFunctionTopHeight = 100;
    private int TableFunctionBottomHeight = 100;
    private int TableFunctionFontSize = 20;
    private int TableFunctionTopFontSize = 20;
    private int TableFunctionBottomFontSize = 20;
    private String Memberinfo = "MEM_MemberNo,MEM_Phone,MEM_NAME,MEM_Points";
    private String MemberHttp = "http://m.ricepon.com:9090/member-web";
    private boolean EnableErrorLog = true;
    private boolean TableFunction_SplitTable = true;
    private boolean TableFunction_FoodList = true;
    private boolean TableFunction_OfflineOrder = true;
    private boolean MainFunction_TableMode = true;
    private boolean TableFunction_ScanBarcode = true;
    private boolean OrderFunction_send = true;
    private boolean TableFunction_PayBill = true;
    private boolean OrderFunction_PrePay = true;
    private int AutoOpen = 0;
    private int OrderNumberShowSize = 20;
    private int OrderNumberFontSize = 7;
    private int OrderNumberChildShowSize = 20;
    private int OrderNumberChildFontSize = 10;

    /**
     * 送單是否自動合併未送食品（只處理未有細項的食品）
     */
    private boolean MergeSendFood = true;
    /**
     * 送單是否自動打印上菜纸
     */
    private boolean AutoPrinterParper = true;

    private Set<String> customizeSetting = new HashSet<>();

    private int screen_w = 1080;
    private int screen_h = 1920;
    private int screen_density_dpi;

    public void adjustSize(Context context, FunctionStyleUtils setting) {
        DisplayMetrics metrics = DeviceUtils.getDisplayMetrics(context);
        screen_w = metrics.widthPixels;
        screen_h = metrics.heightPixels;
        screen_density_dpi = metrics.densityDpi;

        if (!setting.customizeSetting.contains("TableFunctionBottomHeight")) {
            //计算高度/
            setting.TableFunctionBottomHeight = (int) Math.ceil((float) setting.TableFunctionBottomHeight / (float) setting.BaseHeight * (float) setting.screen_h);
        }
        if (!setting.customizeSetting.contains("TableFunctionTopHeight")) {
            //计算高度/
            setting.TableFunctionTopHeight = (int) Math.ceil((float) setting.TableFunctionTopHeight / (float) setting.BaseHeight * (float) setting.screen_h);
        }
        if (!setting.customizeSetting.contains("OrderOperButtonHeight")) {
            //计算高度/
            setting.OrderOperButtonHeight = (int) Math.ceil((float) setting.OrderOperButtonHeight / (float) setting.BaseHeight * (float) setting.screen_h);
        }
        if (!setting.customizeSetting.contains("LayoutBillListHeight")) {
            //计算高度/
            setting.LayoutBillListHeight = (int) Math.ceil((float) setting.LayoutBillListHeight / (float) setting.BaseHeight * (float) setting.screen_h);
        }
        if (!setting.customizeSetting.contains("LayoutQtyHeight")) {
            //计算高度/
            setting.LayoutQtyHeight = (int) Math.ceil((float) setting.LayoutQtyHeight / (float) setting.BaseHeight * (float) setting.screen_h);
        }
        if (!setting.customizeSetting.contains("LayoutQuitHeight")) {
            //计算高度/
            setting.LayoutQuitHeight = (int) Math.ceil((float) setting.LayoutQuitHeight / (float) setting.BaseHeight * (float) setting.screen_h);
        }

        if (!setting.customizeSetting.contains("LayoutFoodTypeHeight")) {
            //计算高度/
            setting.LayoutFoodTypeHeight = (int) Math.ceil((float) setting.LayoutFoodTypeHeight / (float) setting.BaseHeight * (float) setting.screen_h);
        }
        if (!setting.customizeSetting.contains("FoodBtnHeight")) {
            //计算高度/
            Log.e("初始FoodBtnHeight", FoodBtnHeight + "");
            setting.FoodBtnHeight = (int) Math.ceil((float) setting.FoodBtnHeight / (float) setting.BaseHeight * (float) setting.screen_h);
            Log.e("最后得出的FoodBtnHeight", setting.FoodBtnHeight + "");
        }
        if (!setting.customizeSetting.contains("ModBtnHeight")) {
            //计算高度/
            setting.ModBtnHeight = (int) Math.ceil((float) setting.ModBtnHeight / (float) setting.BaseHeight * (float) setting.screen_h);
        }

        if (!setting.customizeSetting.contains("ModFunctionBarHeight")) {
            //计算高度/
            setting.ModFunctionBarHeight = (int) Math.ceil((float) setting.ModFunctionBarHeight / (float) setting.BaseHeight * (float) setting.screen_h);
        }
        if (!setting.customizeSetting.contains("BottomBarHeight")) {
            //计算高度/
            setting.BottomBarHeight = (int) Math.ceil((float) setting.BottomBarHeight / (float) setting.BaseHeight * (float) setting.screen_h);
        }

        if (!setting.customizeSetting.contains("OrderDataOperBtnWidth")) {
            //计算高度/
            OrderDataOperBtnWidth = (int) Math.ceil((float) OrderDataOperBtnWidth / (float) BaseWidth * (float) screen_w);
        }
        if (!customizeSetting.contains("OrderDataOperBtnHeight")) {
            //计算高度/
            setting.OrderDataOperBtnHeight = (int) Math.ceil((float) setting.OrderDataOperBtnHeight / (float) setting.BaseHeight * (float) setting.screen_h);
        }

        float screen_scaledDensity = (float) setting.screen_density_dpi / 160;
        float base_scaledDensity = (float) setting.BaseDpi / 160;
        float rate = (float) (base_scaledDensity / screen_scaledDensity);

        if (!setting.customizeSetting.contains("TableFunctionTopFontSize")) {
            setting.TableFunctionTopFontSize = (int) Math.ceil((float) setting.TableFunctionTopFontSize / (float) setting.BaseWidth * (float) setting.screen_w * rate);///base_scaledDensity*(float)privateClass.screen_scaledDensity);
        }
        if (!setting.customizeSetting.contains("TableFunctionBottomFontSize")) {
            setting.TableFunctionBottomFontSize = (int) Math.ceil((float) setting.TableFunctionBottomFontSize / (float) setting.BaseWidth * (float) setting.screen_w * rate);
        }
        if (!setting.customizeSetting.contains("FoodTypeFontSize")) {
            setting.FoodTypeFontSize = (int) Math.ceil((float) setting.FoodTypeFontSize / (float) setting.BaseWidth * (float) setting.screen_w * rate);
        }
        if (!setting.customizeSetting.contains("FoodFontSize")) {
            setting.FoodFontSize = (int) Math.ceil((float) setting.FoodFontSize / (float) setting.BaseWidth * (float) setting.screen_w * rate);
        }
        if (!setting.customizeSetting.contains("ModFontSize")) {
            setting.ModFontSize = (int) Math.ceil((float) setting.ModFontSize / (float) setting.BaseWidth * (float) setting.screen_w * rate);
        }
        if (!setting.customizeSetting.contains("BillTotalFontSize")) {
            setting.BillTotalFontSize = (int) Math.ceil((float) setting.BillTotalFontSize / (float) setting.BaseWidth * (float) setting.screen_w * rate);
        }
        if (!setting.customizeSetting.contains("BillListFontSize")) {
            Log.e("初始BillListFontSize", setting.BillListFontSize + "");
            setting.BillListFontSize = (int) Math.ceil((float) setting.BillListFontSize / (float) setting.BaseWidth * (float) setting.screen_w * rate);
            Log.e("最后得出的BillListFontSize", BillListFontSize + "");
        }
        if (!setting.customizeSetting.contains("FoodlListFontSize")) {
            setting.FoodlListFontSize = (int) Math.ceil((float) setting.FoodlListFontSize / (float) setting.BaseWidth * (float) setting.screen_w * rate);
        }
        if (!setting.customizeSetting.contains("orderInfoFontSize")) {
            Log.e("初始orderInfoFontSize", setting.orderInfoFontSize + "");
            setting.orderInfoFontSize = (int) Math.ceil((float) setting.orderInfoFontSize / (float) setting.BaseWidth * (float) setting.screen_w * rate);
            Log.e("最后得出的orderInfoFontSize", setting.orderInfoFontSize + "");
        }
        if (!setting.customizeSetting.contains("TableFunctionFontSize")) {
            setting.TableFunctionFontSize = (int) Math.ceil((float) setting.TableFunctionFontSize / (float) setting.BaseWidth * (float) setting.screen_w * rate);
        }
        if (!setting.customizeSetting.contains("OrderNumberFontSize")) {
            setting.OrderNumberFontSize = (int) Math.ceil((float) setting.OrderNumberFontSize / (float) setting.BaseWidth * (float) setting.screen_w * rate);
        }
        if (!setting.customizeSetting.contains("OrderNumberChildFontSize")) {
            setting.OrderNumberChildFontSize = (int) Math.ceil((float) setting.OrderNumberChildFontSize / (float) setting.BaseWidth * (float) setting.screen_w * rate);
        }
    }


}
