package com.gingersoft.gsa.cloud.main.mvp.model.service;

import com.gingersoft.gsa.cloud.common.Api;
import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.CheckVersionRequest;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.RestaurantQrBean;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * Created by Wyh on 2020/2/22.
 */
public interface MainService {

    @Headers({"Domain-Name: update_version"})
    @GET("system/checkAppVersionGsa" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<CheckVersionRequest> checkAppVersion(@Query("version") String version);

    @FormUrlEncoded
    @POST(Api.sync_restaurant_base_table_configuration + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> syncRestaurantExtendedConfiguration(@Field("restaurantId") int restaurantId);

//    @Headers({"Domain-Name: system_url"})/**/
    @POST("user/logout" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<Object> loginOut(@Body RequestBody requestBody);

    @Headers({"Domain-Name: update_version"})
    @POST("restaurant/clearHeartbeat" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<Object> clearHeartbeat(@Body RequestBody requestBody);

    @GET("restaurant/getUrlInfo" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<RestaurantQrBean> getRestaurantQrCode(@Query("restaurantId") String restaurantId);


    @POST("SystemButtonLanguage/getLanguageByBrandId" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getLanguageByBrandId(@Body RequestBody requestBody);

    @POST("posPay/addOperation" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addSettlementOperation();

    @POST("posPay/updateOperation" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateSettlementOperation(@Body RequestBody requestBody);

}
