package com.gingersoft.supply_chain.mvp.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/22
 * Time: 12:36
 * Use:
 */
@Data
public class WarehouseDetailsBean implements Serializable {
    /**
     * name : 去微软
     * purchase : 採購入庫
     * orderNo : JK11820389311
     * foodQuantity : 17
     * totalPrice : 102.0
     * createTime : 2021
     * warningDays :
     */
    private String name;
    private String purchase;
    private String orderNo;
    private double foodQuantity;
    /**
     * true：查詢過數量了。可以顯示數量
     */
    private boolean queriesNumber = true;

    private double totalPrice;
    //    private String createTime;
    private String supplierName;
    /**
     * 單位
     */
    private String unitName;
    private String foodCategoryName;
    /**
     * 入庫時間
     */
    private String warehousingTime;
    /**
     * 採購時間
     */
    private String purchaseTime;
    /**
     * 還有多少天過期，如果是負的，則是已經過期了
     */
    private int distanceExpiresTime;
    /**
     * 預警天數
     */
    private int warningDays;
    /**
     * 消耗狀態,1從未被消耗,2消耗了一部分,3完全消耗
     */
    private int consumeStatus;

    private String remarks;
    /**
     * 入庫詳情ids，逗號分隔
     */
    private String warehousingOrderDetailsIds;
    /**
     * 入庫訂單編號
     */
    private String warehousingOrderNo;
    //入庫
    public static final int TYPE_WAREHOUSING_TYPE = 0;
    /**
     * 出庫詳情ids，逗號分隔
     */
    private String purchaseConsumeNoId;

    private double consumeQuantity;
    //出庫
    public static final int TYPE_DELIVERY_HOUSE_TYPE = 1;

    public final static int WAREHOUSE_STATE_NEVER_CONSUMED = 1;
    public final static int WAREHOUSE_STATE_PART_CONSUMED = 2;
    public final static int WAREHOUSE_STATE_ALL_CONSUMED = 3;

    public WarehouseDetailsBean() {
    }

    public WarehouseDetailsBean(String name, double foodQuantity, String warehousingOrderDetailsIds) {
        this.name = name;
        this.foodQuantity = foodQuantity;
        this.warehousingOrderDetailsIds = warehousingOrderDetailsIds;
    }

    public static WarehouseDetailsBean getWarehousingByConsume(ConsumeWareHousingBean consumeWareHousingBean) {
        WarehouseDetailsBean warehousingBean = new WarehouseDetailsBean();
        warehousingBean.name = consumeWareHousingBean.getName();
        warehousingBean.unitName = consumeWareHousingBean.getUnitName();
        warehousingBean.foodCategoryName = consumeWareHousingBean.getFoodCategoryName();
        warehousingBean.purchase = consumeWareHousingBean.getDescription();
        warehousingBean.foodQuantity = consumeWareHousingBean.getQuantity();
        warehousingBean.purchaseTime = consumeWareHousingBean.getDates();
        warehousingBean.supplierName = consumeWareHousingBean.getSupplierName();
        warehousingBean.purchaseConsumeNoId = consumeWareHousingBean.getPurchaseConsumeNoId();
        warehousingBean.warehousingOrderDetailsIds = consumeWareHousingBean.getWarehousingOrderDetailsIds();
        warehousingBean.remarks = consumeWareHousingBean.getRemarks();
        warehousingBean.totalPrice = consumeWareHousingBean.getTotalPrice();
        warehousingBean.consumeQuantity = consumeWareHousingBean.getConsumeQuantity();
        return warehousingBean;
    }

    public static List<WarehouseDetailsBean> getWarehousingByConsumes(List<ConsumeWareHousingBean> consumeWareHousingBeans) {
        List<WarehouseDetailsBean> warehousings = new ArrayList<>();
        for (ConsumeWareHousingBean consumeWareHousingBean : consumeWareHousingBeans) {
            warehousings.add(getWarehousingByConsume(consumeWareHousingBean));
        }
        return warehousings;
    }
}
