package com.gingersoft.gsa.cloud.database.bean;

import android.graphics.Color;
import android.text.TextUtils;
import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Generated;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.Property;
import org.greenrobot.greendao.annotation.Transient;
import java.util.Date;
import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-02-18
 * 修订历史：2020-02-18
 * 描述：套餐食品關係
 */
@Data
@Entity
public class ComboItem {

    @Property(nameInDb = "_id")
    @Id(autoincrement = true)
    private Long id;

    private Long comId;

    private Long fid;

    private long qty;

    private double diffAmt;

    private long seqNo;

    private long visible;

    private Date createTime;

    private String createBy;

    private Date updateTime;

    private long conditions;

    private long isRT;

    private byte deletes;

    private long posId;

    private long restaurant_id;

    private byte isMainAccount;


//    /**
//     * 廚房單打印主項
//     */
//    private long ktPrintMainItem;
//
//    /**
//     * 0=系統顏色, 1=黑色, 2=紅色
//     */
//    private long printFont;
//    /**
//     * 當金額=0時, 是否打印在帳單上
//     */
//    private long printToBill;
//    /**
//     * 0食品清单打印 账单打印//1食品清单不打印 账单不打印//2食品清单打印 账单不打印//3食品清单不打印 账单打印
//     */
//    private long printTo;
//    /**
//     * 是否打印价格
//     */
//    private long ktShowPrice;
    /**
     * 自定義字段
     */
    @Transient
    private String name;
    @Transient
    private String name1;
    @Transient
    private String name2;
    @Transient
    private long parentId;
    /**
     * 套餐最大選擇數
     */
    @Transient
    private int selectQty = 0;
    /**
     * 默認選中數
     */
    @Transient
    private String defmodifier = "0";
    /**
     * 價格
     */
    @Transient
    private double price = 0.00;
    /**
     * 是否参与折扣#0:不參與;1:參與;
     */
    @Transient
    private long ablediscount;
    /**
     * 是否收取服務費
     */
    @Transient
    private int serviceCharge;
    /*** 是否自動展開*/
    @Transient
    private int autoMode = 0;
    /*** 是否备注细项*/
    @Transient
    private boolean isModifier;
    /**
     * 餐种{@link com.gingersoft.gsa.cloud.constans.FoodSummaryConstans}
     */
    @Transient
    private String foodSummary;
    /**
     * 0=顯示, 1=隱藏, 2=暫停,3=只显示,不操作
     */
    @Transient
    private long invisible;
    @Transient
    /**最大選中數*/
    private String maxNumber = "";
    /**動態的最大選中數*/
    @Transient
    private String currentMaxNumber= "";
    /*** 背景顏色*/
    @Transient
    private int bgColor = Color.parseColor("#067878");
    /*** 字體顏色*/
    @Transient
    private int fontColor = Color.parseColor("#FFFFFF");
    /*** 套餐細項*/
    @Transient
    private Modifier modifier;
    /**
     * 打印設定, 用逗號分隔, *=切紙
     */
    private String printSeting="";
    /**
     * 額外食品加分
     */
    @Transient
    private double pointsAdd;
    /**
     * 額外積分比率
     */
    @Transient
    private long pointsRatio;
    /**
     * 換購食品所需積分
     */
    @Transient
    private double pointsRedeem;



    @Generated(hash = 1579207287)
    public ComboItem(Long id, Long comId, Long fid, long qty, double diffAmt, long seqNo, long visible, Date createTime,
            String createBy, Date updateTime, long conditions, long isRT, byte deletes, long posId, long restaurant_id,
            byte isMainAccount, String printSeting) {
        this.id = id;
        this.comId = comId;
        this.fid = fid;
        this.qty = qty;
        this.diffAmt = diffAmt;
        this.seqNo = seqNo;
        this.visible = visible;
        this.createTime = createTime;
        this.createBy = createBy;
        this.updateTime = updateTime;
        this.conditions = conditions;
        this.isRT = isRT;
        this.deletes = deletes;
        this.posId = posId;
        this.restaurant_id = restaurant_id;
        this.isMainAccount = isMainAccount;
        this.printSeting = printSeting;
    }

    @Generated(hash = 435228340)
    public ComboItem() {
    }

    public boolean isSold() {
        if(!TextUtils.isEmpty(currentMaxNumber) && ("售罄".equals(currentMaxNumber) || "暫停".equals(currentMaxNumber))){
            return true;
        }
        return false;
    }

    public static ComboItem addFoodInfo(Food food, ComboItem foodCombo) {
        foodCombo.setName(food.getFoodName());
        foodCombo.setFid(food.getId());
        foodCombo.setPrice(food.getPrice());
        foodCombo.setAutoMode(food.getAutoMod());
        return foodCombo;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getComId() {
        return this.comId;
    }

    public void setComId(Long comId) {
        this.comId = comId;
    }

    public Long getFid() {
        return this.fid;
    }

    public void setFid(Long fid) {
        this.fid = fid;
    }

    public long getQty() {
        return this.qty;
    }

    public void setQty(long qty) {
        this.qty = qty;
    }

    public double getDiffAmt() {
        return this.diffAmt;
    }

    public void setDiffAmt(double diffAmt) {
        this.diffAmt = diffAmt;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public void setSeqNo(long seqNo) {
        this.seqNo = seqNo;
    }

    public long getVisible() {
        return this.visible;
    }

    public void setVisible(long visible) {
        this.visible = visible;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public long getConditions() {
        return this.conditions;
    }

    public void setConditions(long conditions) {
        this.conditions = conditions;
    }

    public long getIsRT() {
        return this.isRT;
    }

    public void setIsRT(long isRT) {
        this.isRT = isRT;
    }

    public byte getDeletes() {
        return this.deletes;
    }

    public void setDeletes(byte deletes) {
        this.deletes = deletes;
    }

    public long getPosId() {
        return this.posId;
    }

    public void setPosId(long posId) {
        this.posId = posId;
    }

    public long getRestaurant_id() {
        return this.restaurant_id;
    }

    public void setRestaurant_id(long restaurant_id) {
        this.restaurant_id = restaurant_id;
    }

    public byte getIsMainAccount() {
        return this.isMainAccount;
    }

    public void setIsMainAccount(byte isMainAccount) {
        this.isMainAccount = isMainAccount;
    }

    public String getPrintSeting() {
        return this.printSeting;
    }

    public void setPrintSeting(String printSeting) {
        this.printSeting = printSeting;
    }

}
