package com.gingersoft.gsa.cloud.database.bean;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.Property;
import org.greenrobot.greendao.annotation.Transient;

import lombok.Data;

import org.greenrobot.greendao.annotation.Generated;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-04-08
 * 修订历史：2020-04-08
 * 描述：
 */
@Data
@Entity
public class Discount {


    /**
     * ID
     */
    @Property(nameInDb = "_id")
    @Id(autoincrement = true)
    private Long id;

    private int restaurantId;
    /**
     * 金額
     */
    private double amount;
    /**
     * 折扣比例
     */
    private int discountValue;
    /**
     * 类型#0:金额;1:折扣比例;2:自定義金額;3:自定義金額鍵盤輸入;4:免服務費
     */
    private int type;

    public static final byte DISCOUNT_TYPE_AMOUNT = 0;
    public static final byte DISCOUNT_TYPE_RATE = 1;
    public static final byte DISCOUNT_TYPE_CUSTOM_AMOUNT = 2;
    public static final byte DISCOUNT_TYPE_KEYBOARD = 3;
    public static final byte DISCOUNT_TYPE_FREE_SERVICE_CHARGE = 4;
    /**
     * 折扣可使用范围#0:食品;1:账单;2:全部;
     */
    private String discountType;

    public static final byte discount_scope_commodity = 0;
    public static final byte discount_scope_bill = 1;
    public static final byte discount_scope_ALL = 2;
    /**
     * 状态#0:启用;1:禁用;
     */
    private int status;
    /**
     * 折扣描述
     */
    private String remark;
    /**
     * 是否免服務費 0：否，1：是
     */
    private byte freeServiceCharge;
    /**
     * 是否經理批准 0：否，1：是
     */
    private byte managerApproval;
    /**
     * 顏色
     */
    private String color;
    /**
     * 落單類型 0：餐檯模式，1：外賣模式，2：外送模式，3：自取模式
     */
    private String placeOrderType;

    public static final byte ORDER_TYPE_MEAL_STAND = 0;
    public static final byte ORDER_TYPE_TAKEAWAY = 1;
    public static final byte ORDER_TYPE_DELIVERY = 2;
    public static final byte ORDER_TYPE_SELF_COLLECTION = 3;
    /**
     * 折扣上限
     */
    private double discountCap;
    /**
     * 銷售額
     */
    private double salesAmount;
    /**
     * 免稅 0：否，1：是
     */
    private byte taxFree;
    /**
     * 獨佔折扣 0：否，1：是
     */
    private byte exclusive;
    /**
     * 暫停 0：否，1：是
     */
    private byte pause;
    /**
     * 折上折 0：否，1：是
     */
    private byte additionalDiscount;
    /**
     * 只一次 0：否，1：是
     */
    private byte onlyOnce;
    /**
     * 最小賬單金額
     */
    private double minBillAmount;
    /**
     * 扣減積分 0：否，1：是
     */
    private byte pointsDeduction;
    /**
     * 整單免積分 0：否，1：是
     */
    private byte wholeFreePoints;
    /**
     * 最小金額類型 0：合計，1：總金額  默認 1
     */
    private byte amountTypeMin;

    private String beginTime;
    private String endTime;

    /**
     * 自定義字段
     */
    @Transient
    private long memberId = -1;

    @Generated(hash = 1938515536)
    public Discount(Long id, int restaurantId, double amount, int discountValue,
            int type, String discountType, int status, String remark,
            byte freeServiceCharge, byte managerApproval, String color,
            String placeOrderType, double discountCap, double salesAmount,
            byte taxFree, byte exclusive, byte pause, byte additionalDiscount,
            byte onlyOnce, double minBillAmount, byte pointsDeduction,
            byte wholeFreePoints, byte amountTypeMin, String beginTime,
            String endTime) {
        this.id = id;
        this.restaurantId = restaurantId;
        this.amount = amount;
        this.discountValue = discountValue;
        this.type = type;
        this.discountType = discountType;
        this.status = status;
        this.remark = remark;
        this.freeServiceCharge = freeServiceCharge;
        this.managerApproval = managerApproval;
        this.color = color;
        this.placeOrderType = placeOrderType;
        this.discountCap = discountCap;
        this.salesAmount = salesAmount;
        this.taxFree = taxFree;
        this.exclusive = exclusive;
        this.pause = pause;
        this.additionalDiscount = additionalDiscount;
        this.onlyOnce = onlyOnce;
        this.minBillAmount = minBillAmount;
        this.pointsDeduction = pointsDeduction;
        this.wholeFreePoints = wholeFreePoints;
        this.amountTypeMin = amountTypeMin;
        this.beginTime = beginTime;
        this.endTime = endTime;
    }

    @Generated(hash = 1777606421)
    public Discount() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getRestaurantId() {
        return this.restaurantId;
    }

    public void setRestaurantId(int restaurantId) {
        this.restaurantId = restaurantId;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public int getDiscountValue() {
        return this.discountValue;
    }

    public void setDiscountValue(int discountValue) {
        this.discountValue = discountValue;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDiscountType() {
        return this.discountType;
    }

    public void setDiscountType(String discountType) {
        this.discountType = discountType;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public byte getFreeServiceCharge() {
        return this.freeServiceCharge;
    }

    public void setFreeServiceCharge(byte freeServiceCharge) {
        this.freeServiceCharge = freeServiceCharge;
    }

    public byte getManagerApproval() {
        return this.managerApproval;
    }

    public void setManagerApproval(byte managerApproval) {
        this.managerApproval = managerApproval;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getPlaceOrderType() {
        return this.placeOrderType;
    }

    public void setPlaceOrderType(String placeOrderType) {
        this.placeOrderType = placeOrderType;
    }

    public double getDiscountCap() {
        return this.discountCap;
    }

    public void setDiscountCap(double discountCap) {
        this.discountCap = discountCap;
    }

    public double getSalesAmount() {
        return this.salesAmount;
    }

    public void setSalesAmount(double salesAmount) {
        this.salesAmount = salesAmount;
    }

    public byte getTaxFree() {
        return this.taxFree;
    }

    public void setTaxFree(byte taxFree) {
        this.taxFree = taxFree;
    }

    public byte getExclusive() {
        return this.exclusive;
    }

    public void setExclusive(byte exclusive) {
        this.exclusive = exclusive;
    }

    public boolean isPause() {
        return pause == 1;
    }

    public void setPause(byte pause) {
        this.pause = pause;
    }

    public byte getAdditionalDiscount() {
        return this.additionalDiscount;
    }

    public void setAdditionalDiscount(byte additionalDiscount) {
        this.additionalDiscount = additionalDiscount;
    }

    public byte getOnlyOnce() {
        return this.onlyOnce;
    }

    public void setOnlyOnce(byte onlyOnce) {
        this.onlyOnce = onlyOnce;
    }

    public double getMinBillAmount() {
        return this.minBillAmount;
    }

    public void setMinBillAmount(double minBillAmount) {
        this.minBillAmount = minBillAmount;
    }

    public byte getPointsDeduction() {
        return this.pointsDeduction;
    }

    public void setPointsDeduction(byte pointsDeduction) {
        this.pointsDeduction = pointsDeduction;
    }

    public byte getWholeFreePoints() {
        return this.wholeFreePoints;
    }

    public void setWholeFreePoints(byte wholeFreePoints) {
        this.wholeFreePoints = wholeFreePoints;
    }

    public byte getAmountTypeMin() {
        return this.amountTypeMin;
    }

    public void setAmountTypeMin(byte amountTypeMin) {
        this.amountTypeMin = amountTypeMin;
    }

    public String getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public byte getPause() {
        return this.pause;
    }




}
