package com.gingersoft.gsa.cloud.main.mvp.ui.activity.menu;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.main.di.component.DaggerFoodMenuManageComponent;
import com.gingersoft.gsa.cloud.main.mvp.contract.FoodMenuManageContract;
import com.gingersoft.gsa.cloud.main.mvp.presenter.FoodMenuManagePresenter;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu.FoodMenuMangerLeftAdapter;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu.FoodMenuMangerRightAdapter;
import com.gingersoft.gsa.cloud.ui.recylcler.decorator.DividerItemDecoration;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.alpha.QMUIAlphaImageButton;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.Arrays;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 10/27/2020 15:12
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class FoodMenuManageActivity extends BaseActivity<FoodMenuManagePresenter> implements FoodMenuManageContract.View, View.OnClickListener {

    @BindView(R2.id.topbar_food_menu)
    QMUITopBar topbarFoodMenu;
    @BindView(R2.id.btn_add_food_group)
    Button btnAddFoodGroup;
    @BindView(R2.id.rv_food_menu_food_classification)
    RecyclerView leftRv;
    @BindView(R2.id.rv_food_menu_all_food)
    RecyclerView rightRv;


    private List<String> category = Arrays.asList("A食品", "B食品", "C食品", "D食品", "E食品");

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerFoodMenuManageComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_food_menu_manage;
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        leftRv.setLayoutManager(new LinearLayoutManager(mContext));
        leftRv.addItemDecoration(new DividerItemDecoration(mContext, LinearLayoutManager.VERTICAL));

        FoodMenuMangerLeftAdapter foodMenuMangerLeftAdapter = new FoodMenuMangerLeftAdapter(this, category);
        leftRv.setAdapter(foodMenuMangerLeftAdapter);

        String[] foods = new String[50];
        for (int i = 0; i < 50; i++) {
            int x = i / 10;
            String foodName = category.get(x);
            foods[i] = foodName + i;
        }

        rightRv.setLayoutManager(new LinearLayoutManager(mContext));
        rightRv.addItemDecoration(new DividerItemDecoration(mContext, LinearLayoutManager.VERTICAL));
        FoodMenuMangerRightAdapter foodMenuMangerRightAdapter = new FoodMenuMangerRightAdapter(category, foods);
        rightRv.setAdapter(foodMenuMangerRightAdapter);

        foodMenuMangerLeftAdapter.setOnItemClickListener((adapter, view, position) -> {
            int section = foodMenuMangerRightAdapter.getPositionForSection(position);
            foodMenuMangerLeftAdapter.setSelectIndex(position);
            ((LinearLayoutManager)rightRv.getLayoutManager()).scrollToPositionWithOffset(section, 0);
        });

        rightRv.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);

            }

            @Override
            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);

            }
        });
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
        topbarFoodMenu.setTitle("餐牌管理");
        topbarFoodMenu.addLeftBackImageButton().setOnClickListener(v -> killMyself());
        QMUIAlphaImageButton rightButton = topbarFoodMenu.addRightImageButton(R.drawable.ic_add_have_border, R.id.topbar_right_add_button);
        rightButton.setOnClickListener(v -> {
            launchActivity(new Intent(mContext, NewFoodActivity.class));
        });
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null) {
            LoadingDialog.showDialogForLoading(this, message, true);
        } else {
            LoadingDialog.showDialogForLoading(this);
        }
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        ArmsUtils.makeText(this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @OnClick({R2.id.btn_add_food_group})
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.btn_add_food_group) {
            launchActivity(new Intent(mContext, NewAddFoodGroupActivity.class));
        }
    }
}
