package com.gingersoft.gsa.cloud.main.mvp.ui.activity.menu;

import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.main.di.component.DaggerNewAddFoodGroupComponent;
import com.gingersoft.gsa.cloud.main.mvp.contract.NewAddFoodGroupContract;
import com.gingersoft.gsa.cloud.main.mvp.presenter.NewAddFoodGroupPresenter;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu.FoodMenuAdapter;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.widget.QMUITopBar;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * 新增食品組----編輯食品組
 * 傳了食品組信息就是編輯
 */
public class NewAddFoodGroupActivity extends BaseActivity<NewAddFoodGroupPresenter> implements NewAddFoodGroupContract.View {

    @BindView(R2.id.topbar_list)
    QMUITopBar topbarList;
    @BindView(R2.id.rv_content)
    RecyclerView rvContent;
    @BindView(R2.id.btn_save)
    QMUIAlphaButton btnSave;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerNewAddFoodGroupComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_new_add_food_group;
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        //添加自定义分割线
        DividerItemDecoration divider = new DividerItemDecoration(this, DividerItemDecoration.VERTICAL);
        Drawable drawable = ContextCompat.getDrawable(this, R.drawable.divider_f5);
        assert drawable != null;
        divider.setDrawable(drawable);
        rvContent.addItemDecoration(divider);
        rvContent.setLayoutManager(new LinearLayoutManager(mContext));
        rvContent.setAdapter(FoodMenuAdapter.getFoodMenuAdapter(mContext, FoodMenuAdapter.NEW_FOOD_GROUP));

    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
        topbarList.setTitle("新增食品組");
        topbarList.addLeftBackImageButton().setOnClickListener(v -> killMyself());
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null) {
            LoadingDialog.showDialogForLoading(this, message, true);
        } else {
            LoadingDialog.showDialogForLoading(this);
        }
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        ArmsUtils.makeText(this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

}
