package com.gingersoft.gsa.cloud.main.mvp.ui.activity.menu;

import android.content.Intent;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.viewpager.widget.ViewPager;

import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.main.di.component.DaggerNewFoodComponent;
import com.gingersoft.gsa.cloud.main.mvp.contract.NewFoodContract;
import com.gingersoft.gsa.cloud.main.mvp.presenter.NewFoodPresenter;
import com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.FoodItemsFragment;
import com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.FoodPropertiesFragment;
import com.gingersoft.gsa.cloud.main.mvp.ui.fragment.menu.FoodSetFragment;
import com.gingersoft.gsa.cloud.ui.adapter.TabFragmentAdapter;
import com.gingersoft.gsa.cloud.ui.view.MyTableView;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseFragmentActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 10/27/2020 15:23
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class NewFoodActivity extends BaseFragmentActivity<NewFoodPresenter> implements NewFoodContract.View {

    @BindView(R2.id.topbar_new_food)
    QMUITopBar topbarNewFood;
    @BindView(R2.id.table_view_new_food)
    MyTableView tableViewNewFood;
    @BindView(R2.id.new_food_viewpager)
    ViewPager newFoodViewpager;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerNewFoodComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_new_food;
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        initViewPager();
    }

    private void initViewPager() {
        List<String> titles = new ArrayList<>();
        List<Fragment> mFragments = new ArrayList<>();
        titles.add("基本屬性");
        titles.add("細項");
        titles.add("套餐");

        mFragments.add(FoodPropertiesFragment.newInstance());
        mFragments.add(FoodItemsFragment.newInstance());
        mFragments.add(FoodSetFragment.newInstance());

        //实例化适配器
        TabFragmentAdapter mTabFragmentAdapter = new TabFragmentAdapter(getSupportFragmentManager(), 1);
        //设置加载的Fragment集合
        mTabFragmentAdapter.setFragments(mFragments);
        //设置Viewpager的适配器
        newFoodViewpager.setAdapter(mTabFragmentAdapter);
        //TabLayout绑定ViewPager
        tableViewNewFood.setTitles(titles).setupWithViewPager(newFoodViewpager);
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
        topbarNewFood.setTitle("新增食品");
        topbarNewFood.addLeftImageButton(R.drawable.icon_return, R.id.iv_left_back).setOnClickListener(v -> finish());
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null) {
            LoadingDialog.showDialogForLoading(this, message, true);
        } else {
            LoadingDialog.showDialogForLoading(this);
        }
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        ArmsUtils.makeText(this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

}
