package com.gingersoft.gsa.cloud.main.mvp.ui.activity.menu;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.main.di.component.DaggerSelectFoodGroupComponent;
import com.gingersoft.gsa.cloud.main.mvp.contract.SelectFoodGroupContract;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.FoodGroupBean;
import com.gingersoft.gsa.cloud.main.mvp.presenter.SelectFoodGroupPresenter;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu.FoodGroupEditAdapter;
import com.gingersoft.gsa.cloud.ui.recylcler.decorator.DividerItemDecoration;
import com.gingersoft.gsa.cloud.ui.utils.AppDialog;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * 選擇食品組
 */
public class SelectFoodGroupActivity extends BaseActivity<SelectFoodGroupPresenter> implements SelectFoodGroupContract.View, View.OnClickListener {

    @BindView(R2.id.topbar_list)
    QMUITopBar topbarList;
    @BindView(R2.id.rv_content)
    RecyclerView rvContent;
    @BindView(R2.id.btn_save)
    QMUIAlphaButton btnSave;

    private FoodGroupEditAdapter foodGroupEditAdapter;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerSelectFoodGroupComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_select_food_group;
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        btnSave.setVisibility(View.GONE);

        List<FoodGroupBean> data = new ArrayList<>();
        for (int i = 0; i < 10; i++) {
            data.add(new FoodGroupBean("食品組名稱" + i));
        }
        rvContent.addItemDecoration(new DividerItemDecoration(mContext, LinearLayoutManager.VERTICAL));
        rvContent.setLayoutManager(new LinearLayoutManager(mContext));
        foodGroupEditAdapter = new FoodGroupEditAdapter(data);
        rvContent.setAdapter(foodGroupEditAdapter);
        foodGroupEditAdapter.setOnItemClickListener((adapter, view, position) -> launchActivity(new Intent(mContext, NewAddFoodGroupActivity.class)));
        foodGroupEditAdapter.setOnItemChildClickListener((adapter, view, position) -> {
            if (view.getId() == R.id.iv_food_group_delete) {
                new AppDialog().showWaringDialog(mContext, "是否確認刪除" + data.get(position).getFoodGroupName(), (view1, dialog) -> {
                    foodGroupEditAdapter.removeAt(position);
                    dialog.dismiss();
                });
            }
        });
    }

    @Override
    public void initIntent() {
    }

    @Override
    public void initTopBar() {
        topbarList.setTitle("選擇食品組");
        topbarList.addLeftImageButton(R.drawable.icon_return, R.id.iv_left_back).setOnClickListener(v -> finish());
        topbarList.addRightImageButton(R.drawable.ic_white_add, R.id.topbar_right_add_button).setOnClickListener(this);
        topbarList.addRightImageButton(R.drawable.ic_white_edit, R.id.topbar_right_edit_button).setOnClickListener(this);
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null) {
            LoadingDialog.showDialogForLoading(this, message, true);
        } else {
            LoadingDialog.showDialogForLoading(this);
        }
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        ArmsUtils.makeText(this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.topbar_right_add_button) {
            launchActivity(new Intent(this, NewAddFoodGroupActivity.class));
        } else if (viewId == R.id.topbar_right_edit_button) {
            if (foodGroupEditAdapter != null) {
                foodGroupEditAdapter.setShowEdit();
            }
        }
    }
}
