package com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu;

import android.content.Context;

import com.chad.library.adapter.base.BaseProviderMultiAdapter;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.FoodMenuEditBean;
import com.gingersoft.gsa.cloud.main.mvp.ui.activity.menu.SelectFoodGroupActivity;
import com.gingersoft.gsa.cloud.main.mvp.ui.activity.menu.SelectFoodTypeActivity;
import com.gingersoft.gsa.cloud.main.mvp.ui.activity.menu.SelectTimePeriodActivity;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import static com.gingersoft.gsa.cloud.base.utils.time.TimeUtils.DATE_FORMAT_DATE;

/**
 * @author admin
 */
public class FoodMenuAdapter extends BaseProviderMultiAdapter<FoodMenuEditBean> {
    public final static int NEW_FOOD_GROUP = 1;
    public final static int NEW_FOOD_PROPERTIES = 2;
    public final static int NEW_FOOD_TYPE = 3;
    public final static int NEW_TIME_PERIOD = 4;

    private static FoodMenuEditBean showClient;

    public static FoodMenuAdapter getFoodMenuAdapter(Context context, int listType) {
        List<FoodMenuEditBean> foodMenuEditBeans;
        switch (listType) {
            case NEW_FOOD_GROUP:
                foodMenuEditBeans = getNewFoodGroupData();
                break;
            case NEW_FOOD_PROPERTIES:
                foodMenuEditBeans = getNewFoodProperties();
                break;
            case NEW_FOOD_TYPE:
                foodMenuEditBeans = getNewFoodType();
                break;
            case NEW_TIME_PERIOD:
                foodMenuEditBeans = getNewTimePeriod();
                break;
            default:
                foodMenuEditBeans = null;
                break;
        }
        return new FoodMenuAdapter(context, foodMenuEditBeans);
    }

    public FoodMenuAdapter(Context context, List<FoodMenuEditBean> foodMenuEditBeans) {
        super(foodMenuEditBeans);
        addItemProvider(new ThickLineProvider());
        addItemProvider(new InputItemProvider());
        addItemProvider(new SelectItemProvider(context));
        addItemProvider(new BooleanItemProvider());
        addItemProvider(new CheckBoxItemProvider(context));
        addItemProvider(new PicUploadPicProvider(context));
    }

    @Override
    protected int getItemType(@NotNull List<? extends FoodMenuEditBean> list, int i) {
        return list.get(i).getItemType();
    }

    /**
     * 新增食品組
     *
     * @return
     */
    public static List<FoodMenuEditBean> getNewFoodGroupData() {
        List<FoodMenuEditBean> foodMenuEditBeans = new ArrayList<>();
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品組名稱1", true, "請輸入食品組名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品組名稱2", false, "請輸入食品組名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品組名稱3", false, "請輸入食品組名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "時段", false, "默認為全時段", SelectTimePeriodActivity.class));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "餐種", false, "請選擇餐種", SelectFoodTypeActivity.class));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_THICK_LINE));

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "顯示狀態", false, true, true));

        List<FoodMenuEditBean.ShowClient> checkBoxList = new ArrayList<>();
        checkBoxList.add(new FoodMenuEditBean.ShowClient("H5", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("GSA", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("APP", false));
        showClient = new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_CHECKBOX, "顯示端", false, true, checkBoxList);
        foodMenuEditBeans.add(showClient);
        return foodMenuEditBeans;
    }

    public void removeClient() {
        this.remove(showClient);
    }

    public void addClient() {
        this.addData(showClient);
    }

    /**
     * 新增食品的基本屬性
     *
     * @return
     */
    public static List<FoodMenuEditBean> getNewFoodProperties() {
        List<FoodMenuEditBean> foodMenuEditBeans = new ArrayList<>();
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "食品組", true, "請選擇食品組", SelectFoodGroupActivity.class));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品名稱1", true, "請輸入食品名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品名稱2", false, "請輸入食品名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品名稱3", false, "請輸入食品名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品金額", true, "請輸入食品金額"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品原價", true, "請輸入食品原價"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "打印位置", true, "請選擇打印位置"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "餐種", true, "請選擇餐種", SelectFoodTypeActivity.class));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "時段", false, "全時段", SelectTimePeriodActivity.class));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "食品描述", false, ""));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_THICK_LINE));

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "啟用", false, true));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "折扣", false, false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "服務費", false, false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "打印至賬單", false, false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "打印主項", false, false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_THICK_LINE));

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_UPLOAD_PIC, "圖片上傳", true));
        return foodMenuEditBeans;
    }

    /**
     * 新增餐種
     *
     * @return
     */
    public static List<FoodMenuEditBean> getNewFoodType() {
        List<FoodMenuEditBean> foodMenuEditBeans = new ArrayList<>();
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "餐種名稱", true, "請選擇餐種名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_BOOLEAN, "是否生效", false, true));
        return foodMenuEditBeans;
    }

    /**
     * 新增時段
     *
     * @return
     */
    public static List<FoodMenuEditBean> getNewTimePeriod() {
        List<FoodMenuEditBean> foodMenuEditBeans = new ArrayList<>();
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "時段名稱1", true, "請輸入時段名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "時段名稱2", false, "請輸入時段名稱"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT, "時段名稱3", false, "請輸入時段名稱"));

        Calendar calendar = Calendar.getInstance();

        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "開始日期", false, "", DATE_FORMAT_DATE.format(calendar.getTime())));
        calendar.set(Calendar.YEAR, calendar.get(Calendar.YEAR) + 10);
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "結束日期", false, "", DATE_FORMAT_DATE.format(calendar.getTime())));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "開始時間", false,"","00:00:00"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_SELECT, "結束時間", false,"","23:59:59"));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_THICK_LINE));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_CHECKBOX, "週期", false));

        List<FoodMenuEditBean.ShowClient> checkBoxList = new ArrayList<>();
        checkBoxList.add(new FoodMenuEditBean.ShowClient("假期", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("週一", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("週二", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("週三", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("週四", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("週五", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("週六", false));
        checkBoxList.add(new FoodMenuEditBean.ShowClient("週日", false));
        foodMenuEditBeans.add(new FoodMenuEditBean(FoodMenuEditBean.EDIT_FOOD_ITEM_CHECKBOX, "", false, checkBoxList));
        return foodMenuEditBeans;
    }
}
