package com.gingersoft.gsa.cloud.main.mvp.ui.adapter.foodmenu;

import android.widget.EditText;

import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.FoodMenuEditBean;

import org.jetbrains.annotations.NotNull;

/**
 * @author admin
 */
public class InputItemProvider extends FoodMenuItemProvider {

    @Override
    public int getItemViewType() {
        return FoodMenuEditBean.EDIT_FOOD_ITEM_INPUT;
    }

    @Override
    public int getLayoutId() {
        return R.layout.item_input;
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, FoodMenuEditBean foodMenuEditBean) {
        super.convert(baseViewHolder, foodMenuEditBean);
        EditText editText = baseViewHolder.getView(R.id.ed_food_menu_value);
        if (TextUtil.isNotEmptyOrNullOrUndefined(foodMenuEditBean.getShowValue())) {
            editText.setText(foodMenuEditBean.getShowValue());
        } else if (TextUtil.isNotEmptyOrNullOrUndefined(foodMenuEditBean.getHintText())) {
            editText.setHint(foodMenuEditBean.getHintText());
        }
    }
}
