package com.gingersoft.gsa.cloud.table.mvp.model.service;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.table.bean.TableBean;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.BaseOrderRespose;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.TableDetail;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2019-12-28
 * 修订历史：2019-12-28
 * 描述：
 */
public interface TableService {

    @GET("restaurantTable/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<TableBean> getTables(@Query("restaurantId") int restaurantId);

    @GET("restaurantTable/get" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<TableDetail> getTable(@Query("id") int table, @Query("tableNumber") String tableNumber);

    @POST("restaurantTable/kickOff" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseOrderRespose> openTable(@Body RequestBody requestBody);

    @POST("restaurantTable/update/table" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseOrderRespose> turnTable(@Body RequestBody requestBody);

    @POST("restaurantTable/set/status" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseOrderRespose> initTable(@Body RequestBody requestBody);

    @GET("restaurantTable/getSplitTableAvailable" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getSplitTables(@Query("tableId") int tableId);

    @GET("restaurantTable/getSplitTable" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> splitTable(@Query("tableId") int tableId);

    @Headers({"Domain-Name: ricepon_restaurant"})
    @GET("summary/getSummaryBusinessList" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getFoodSummarys(@Query("restaurantId") int restaurantId, @Query("isDefault") boolean isDefault, @Query("businessType") byte businessType);
}
