package com.gingersoft.gsa.cloud.table.mvp.model.table.action;

import android.app.Activity;
import android.content.Context;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.table.bean.TableBean;
import com.gingersoft.gsa.cloud.base.utils.JsonUtils;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.FoodSummary;
import com.gingersoft.gsa.cloud.table.mvp.presenter.TablePresenter;
import com.gingersoft.gsa.cloud.table.mvp.ui.widget.SkyOrderDialog;
import com.gingersoft.gsa.cloud.ui.widget.dialog.BaseRetryDialog;

import java.util.List;


/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-23
 * 修订历史：2020-09-23
 * 描述：餐檯模式-打印skyorder碼{@link com.gingersoft.gsa.cloud.table.mvp.ui.activity.TableActivity}
 */
public class PrintSkyOrderAction extends TableAction {

    private TablePresenter mTablePresenter;
    private SkyOrderDialog mSkyOrderDialog;

    public PrintSkyOrderAction(Activity context, TablePresenter tablePresenter) {
        super(context, "打印skyorder", "請選擇檯號", "");
        this.mTablePresenter = tablePresenter;
    }

    @Override
    public void action(TableBean.DataBean dataBean) {
        showSkyOrderDialog();
    }

    @Override
    public boolean filterTableCondition(TableBean.DataBean dataBean) {
        return true;
    }

    @Override
    public void destroy() {
        mTablePresenter = null;
        if (mSkyOrderDialog != null) {
            mSkyOrderDialog.dismiss();
            mSkyOrderDialog = null;
        }
    }

    public void showSkyOrderDialog() {
        if (mSkyOrderDialog == null) {
            mSkyOrderDialog = new SkyOrderDialog(mContext).build();
            mSkyOrderDialog.setOnRetryListener(new BaseRetryDialog.OnRetryListener() {
                @Override
                public void onRetryClick() {
                    getFoodSummarys();
                }
            });
            mSkyOrderDialog.setCallbackListener(new SkyOrderDialog.OnCallbackListener() {

                @Override
                public void lockState(boolean state) {
                    skyOrderLockStateAction(state);
                }

                @Override
                public void onPrint() {

                }
            });
            getFoodSummarys();
        }
        mSkyOrderDialog.show();
    }

    private void getFoodSummarys(){
        mTablePresenter.getFoodSummarys(new OnNetworkCallbackListener<BaseResult>() {

            @Override
            public void onResult(BaseResult result) {
                if (result.isSuccess()) {
                    if (result.getData() != null) {
                        List<FoodSummary> foodSummaryList = JsonUtils.parseArray(result.getData(), FoodSummary.class);
                        mSkyOrderDialog.updateFoodSummaryList(foodSummaryList);
                    } else {
                        mSkyOrderDialog.showEmptyView(true,0,null);
                    }
                } else {
                    mSkyOrderDialog.showEmptyView(false,0,null);
                }
                mSkyOrderDialog.setProgressVisibility(false);
            }

            @Override
            public void onError(Throwable t) {
                mSkyOrderDialog.showEmptyView(false,0,t);
                mSkyOrderDialog.setProgressVisibility(false);
            }
        });
        mSkyOrderDialog.setProgressVisibility(true);
    }
}
