package com.gingersoft.gsa.cloud.main.mvp.ui.adapter;

import android.content.Context;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.SalesFoodsBean;

import java.util.List;

import static java.math.BigDecimal.ROUND_HALF_UP;

/**
 * Created by Wyh on 2020/2/24.
 */
public class FoodRankingAdapter extends BaseQuickAdapter<SalesFoodsBean.DataBean.SalesRankingBean, BaseViewHolder> {

    private Context mContext;
    private double totalAmount;//所有菜品加起來的銷售額
    private int totalNum;//所有菜品加起來的銷售數量

    public FoodRankingAdapter(Context mContext, @Nullable List<SalesFoodsBean.DataBean.SalesRankingBean> data, double totalAmount, int totalNum) {
        super(R.layout.item_food_ranking, data);
        this.mContext = mContext;
        this.totalAmount = totalAmount;
        this.totalNum = totalNum;
    }

    @Override
    public int getItemCount() {
        return getData().size() > 11 ? 11 : getData().size();
    }

    @Override
    protected void convert(BaseViewHolder helper, SalesFoodsBean.DataBean.SalesRankingBean item) {
        if (helper.getAdapterPosition() == 0) {
            helper.setTextColor(R.id.tv_ranking_foodname, mContext.getResources().getColor(R.color.theme_hint_color));
            helper.setTextColor(R.id.tv_ranking_food_sales_num, mContext.getResources().getColor(R.color.theme_hint_color));
            helper.setTextColor(R.id.tv_ranking_food_sales_amount, mContext.getResources().getColor(R.color.theme_hint_color));
            helper.setTextColor(R.id.tv_ranking_food_unit_price, mContext.getResources().getColor(R.color.theme_hint_color));
            helper.setTextColor(R.id.tv_ranking_proportion_quantity, mContext.getResources().getColor(R.color.theme_hint_color));
            helper.setTextColor(R.id.tv_ranking_ratio_amount, mContext.getResources().getColor(R.color.theme_hint_color));

            helper.setText(R.id.tv_ranking_foodname, "食品名稱");
            helper.setText(R.id.tv_ranking_food_sales_num, "銷售數量");
            helper.setText(R.id.tv_ranking_food_sales_amount, "銷售金額");
            helper.setText(R.id.tv_ranking_food_unit_price, "單價");
            helper.setText(R.id.tv_ranking_proportion_quantity, "數量佔比");
            helper.setText(R.id.tv_ranking_ratio_amount, "金額佔比");
        } else {
            helper.setTextColor(R.id.tv_ranking_foodname, mContext.getResources().getColor(R.color.color_8f));
            helper.setTextColor(R.id.tv_ranking_food_sales_num, mContext.getResources().getColor(R.color.color_3c));
            helper.setTextColor(R.id.tv_ranking_food_sales_amount, mContext.getResources().getColor(R.color.color_3c));
            helper.setTextColor(R.id.tv_ranking_food_unit_price, mContext.getResources().getColor(R.color.color_3c));
            helper.setTextColor(R.id.tv_ranking_proportion_quantity, mContext.getResources().getColor(R.color.color_3c));
            helper.setTextColor(R.id.tv_ranking_ratio_amount, mContext.getResources().getColor(R.color.color_3c));
            if (item != null) {
                helper.setText(R.id.tv_ranking_food_unit_price, item.getPrice() + "");
                helper.setText(R.id.tv_ranking_foodname, item.getProductName());
                helper.setText(R.id.tv_ranking_food_sales_num, item.getNumber() + "");
                helper.setText(R.id.tv_ranking_food_sales_amount, item.getAmount() + "");
                helper.setText(R.id.tv_ranking_proportion_quantity, (MoneyUtil.priceCalculation(MoneyUtil.divide(item.getNumber(), totalNum, 2, ROUND_HALF_UP), 100)) + "%");
                helper.setText(R.id.tv_ranking_ratio_amount, (MoneyUtil.priceCalculation(MoneyUtil.divide(item.getAmount(), totalAmount, 2, ROUND_HALF_UP), 100)) + "%");
            }
        }
    }
}
