package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.database.bean.Function;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.base.common.bean.TableBean;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;

import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/8/31
 * 修订历史：2018/8/31
 * 描述：餐檯底部功能列表
 */

public class BottomFunctionAdapter extends DefaultAdapter<Function> {

    private Context mContext;

    public BottomFunctionAdapter(Context context, List<Function> infos) {
        super(infos);
        this.mContext = context;
    }


    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<Function> getHolder(View v, int viewType) {
        return new BottomFunctionItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.table_item_bottom_function;
    }

    class BottomFunctionItemHolder extends BaseHolder<Function> {

        @BindView(R2.id.tv_name)
        TextView tv_name;
        @BindView(R2.id.iv_icon)
        ImageView iv_icon;

        public BottomFunctionItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(Function item, int position) {

            initItemData(item);
        }

        private void initItemData(Function item) {

            tv_name.setText(item.getResName());
            iv_icon.setImageResource(item.getIcRes());
        }
    }


//    private OnItemClickListener mOnItemClickListener;
//
//    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
//        mOnItemClickListener = onItemClickListener;
//    }
//
//    public interface OnItemClickListener {
//
//        void onItemClick(TableBean.DataBean datasBean, int position);
//
//    }
}
