package com.gingersoft.gsa.cloud.table.mvp.ui.fragment;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.common.bean.TableBean;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.di.component.DaggerFineItemOneselfComponent;
import com.gingersoft.gsa.cloud.table.mvp.contract.FineItemOneselfContract;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.SoldoutCtrFood;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.gingersoft.gsa.cloud.table.mvp.presenter.FineItemOneselfPresenter;
import org.simple.eventbus.Subscriber;

import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/19/2020 22:16
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class FineItemOneselfFragment extends BaseFragment<FineItemOneselfPresenter> implements FineItemOneselfContract.View {

    @BindView(R2.id.rv_combo)
    RecyclerView rv_combo;
    @BindView(R2.id.rv_modifier)
    RecyclerView rv_modifier;

    private long mFid;

    public static FineItemOneselfFragment newInstance() {
        FineItemOneselfFragment fragment = new FineItemOneselfFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerFineItemOneselfComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.table_fragment_fine_itemoneself, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        mPresenter.initAdapter();
        mPresenter.initItemListener(mContext);
    }

    public void loadComboData(Long fid) {
        if(fid != null){
            this.mFid = fid;
        }
        mPresenter.loadComboData(mFid);
    }

    public void setSoldoutFoodList_Full(List<SoldoutCtrFood> soldoutCtrList){
        mPresenter.setSoldoutFoodList_Full(soldoutCtrList);
    }

    public void updateSoldoutFoodList_Full(){
        mPresenter.updateSoldoutFoodList_Full();
    }

    @Override
    public void setData(@Nullable Object data) {
    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(getCurrentActivity(), message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {

    }

    @Override
    public Activity getCurrentActivity() {
        return (Activity) mContext;
    }

    @Override
    public void setComboAdapter(DefaultAdapter adapter) {
//        rv_combo.setAdapter(adapter);
    }

    @Override
    public void setModifierAdapter(DefaultAdapter adapter) {
        rv_modifier.setAdapter(adapter);
    }

    @Override
    public void setModifierTop(int margins) {
        LinearLayout.LayoutParams layoutParam = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        layoutParam.setMargins(0, margins, 0, 0);
        rv_modifier.setLayoutParams(layoutParam);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        //使dialog的生命周期与Fragment同步
        hideLoading();
    }
}
