package com.gingersoft.gsa.other_order_mode.ui.adapter

import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.gingersoft.gsa.other_order_mode.R
import com.gingersoft.gsa.other_order_mode.data.model.bean.BillBean

class PayBillAdapter(billBeans: List<BillBean>) : BaseQuickAdapter<BillBean, BaseViewHolder>(R.layout.item_pay_bill, billBeans) {

    override fun convert(helper: BaseViewHolder, item: BillBean) {
        helper.setText(R.id.tv_item_pay_name, item.name)
        helper.setText(R.id.tv_item_pay_amount, item.amount.toString())
        if(item.isRed == 0){
            helper.setTextColor(R.id.tv_item_pay_name, helper.itemView.context.resources.getColor(R.color.color_3c))
            helper.setTextColor(R.id.tv_item_pay_name, helper.itemView.context.resources.getColor(R.color.color_3c))
        } else {
            helper.setTextColor(R.id.tv_item_pay_name, helper.itemView.context.resources.getColor(R.color.discount_red))
            helper.setTextColor(R.id.tv_item_pay_name, helper.itemView.context.resources.getColor(R.color.discount_red))
        }

    }

}