package com.gingersoft.gsa.cloud.login.mvp.contract;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.core.restaurant.bean.BrandsBean;
import com.gingersoft.gsa.cloud.login.mvp.bean.LoginLimitBean;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;
import java.util.List;
import io.reactivex.Observable;
import okhttp3.RequestBody;


public interface ChooseRestaurantContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {
        void saveRestaurantListInfo(List<BrandsBean.BrandsData> brands);

        void jumpMainActivity();

        void jumpDownloadActivity();

        void jumpActivity(Class activity);

        void showLoginLimit(List<LoginLimitBean> loginLimitBeans);

        void kickOut();
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        Observable<BrandsBean> getRestaurantList();

        Observable<BaseResult> getLoginLimit(int restaurantId);

        Observable<Object> loginOut(int userId, RequestBody requestBody);
    }
}
