package com.gingersoft.gsa.cloud.main.mvp.presenter;

import android.app.Application;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.utils.JsonUtils;
import com.gingersoft.gsa.cloud.database.bean.Language;
import com.gingersoft.gsa.cloud.database.utils.LanguageDaoUtils;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.LanguageType;
import com.jess.arms.integration.AppManager;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.http.imageloader.ImageLoader;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import okhttp3.FormBody;
import okhttp3.RequestBody;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.main.mvp.contract.LanguageContract;
import com.jess.arms.utils.RxLifecycleUtils;

import java.util.List;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 07/11/2020 14:51
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class LanguagePresenter extends BasePresenter<LanguageContract.Model, LanguageContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    @Inject
    public LanguagePresenter(LanguageContract.Model model, LanguageContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void getLanguageByBrandId(long brandId) {
        RequestBody requestBody = new FormBody.Builder()
                .add("brandId", String.valueOf(brandId))
                .build();
        mModel.getLanguageByBrandId(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(null))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull BaseResult result) {
                        if (result != null && result.isSuccess()) {
                            if (result.getData() != null) {
                                List<LanguageType> languageList = JsonUtils.parseArray(result.getData(), LanguageType.class);
                                if (languageList != null) {
                                    mRootView.returnLanguageData(languageList);
                                }
                            }
                        } else {
                            mRootView.showMessage(result.getErrMsg());
                        }
                    }
                });
    }

    public void getByLanguageId(List<LanguageType> languageTypeList, int position, int systemType, BaseQuickAdapter adapter) {
        RequestBody requestBody = new FormBody.Builder()
                .add("languageId", String.valueOf(languageTypeList.get(position).getId()))
                .add("systemType", String.valueOf(systemType))
                .build();
        mModel.getByLanguageId(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(null))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull BaseResult result) {
                        if (result != null && result.isSuccess()) {
                            if (result.getData() != null) {
                                List<Language> languageList = JsonUtils.parseArray(result.getData(), Language.class);
                                if (languageList != null) {
                                    for (LanguageType item : languageTypeList) {
                                        item.setSelected(false);
                                    }
                                    languageTypeList.get(position).setSelected(true);
                                    adapter.notifyDataSetChanged();

                                    LanguageDaoUtils daoUtils = new LanguageDaoUtils(mApplication);
                                    boolean status =daoUtils.insertMultLanguage(languageList);
                                    if(status){
                                        mRootView.showMessage("插入語言表成功");
                                    }else {
                                        mRootView.showMessage("插入語言表失敗");
                                    }
                                }
                            }
                        } else {
                            mRootView.showMessage(result.getErrMsg());
                        }
                    }
                });
    }

}
