package com.gingersoft.supply_chain.mvp.contract;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.supply_chain.mvp.bean.FoodCategoryResultBean;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;
import com.gingersoft.supply_chain.mvp.content.Constant;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 11/28/2020 10:14
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface CategoryContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {
        /**
         * 加載一級級分類，用於新增、修改、刪除分類後，刷新頁面
         *
         * @param data 分類
         */
        void loadCategoryInfo(List<OrderCategoryBean.FoodCategoryTrees> data);

        /**
         * 加載二級分類，用於新增、修改、刪除二級分類後，刷新頁面
         *
         * @param data 分類
         */
        void loadSecondCategory(List<OrderCategoryBean.FoodCategoryTrees> data);

        /**
         * 加載三級分類，用於新增、修改、刪除三級分類後，刷新頁面
         *
         * @param data 分類
         */
        void loadThirdCategory(List<OrderCategoryBean.FoodCategoryTrees> data);

        /**
         * 新增分類
         *
         * @param categoryTrees 分類信息
         * @param hierarchy     新增的是第幾級分類
         */
        void addCategory(OrderCategoryBean.FoodCategoryTrees categoryTrees, int hierarchy);

        /**
         * 修改或刪除分類
         *
         * @param type         操作類型：刪除或修改  Constant.DELETE  Constant.UPDATE
         * @param hierarchy    第幾級分類
         * @param position     分類下標
         * @param categoryName 分類名稱
         */
        void updateCategory(int type, int hierarchy, String categoryName, int position);

        void onError();
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        Observable<FoodCategoryResultBean> getFoodCategoryList(Map<String, Object> map);

        Observable<OrderCategoryBean> getCategoryTrees(Map<String, Object> map);

        Observable<BaseResult> createFoodCategory(RequestBody requestBody);

        Observable<BaseResult> updateFoodCategory(RequestBody requestBody);

        Observable<BaseResult> deleteFoodCategory(RequestBody requestBody);
    }
}
