package com.gingersoft.gsa.cloud.pay.pos.hywebpos.command;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;

import com.billy.cc.core.component.CC;
import com.etps.aca.lib.action.ICommand;
import com.etps.aca.lib.activity.CommandActivity;
import com.etps.aca.lib.constant.Constant;
import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.common.constans.PrintConstans;
import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.gingersoft.gsa.cloud.common.utils.ReflectionUtils;
import com.gingersoft.gsa.cloud.common.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.common.utils.log.LogUtil;
import com.gingersoft.gsa.cloud.component.ComponentAction;
import com.gingersoft.gsa.cloud.component.ComponentName;
import com.gingersoft.gsa.cloud.pay.contract.PayExceptionCode;
import com.gingersoft.gsa.cloud.pay.pos.IPosAction;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.AdjustTipRespose;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.HywebPosResponse;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.RefundRespose;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.RetrievalRespose;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.SaleRespose;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.SettlementRespose;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.VoidRespose;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.constant.PayStatusCode;
import com.jess.arms.integration.AppManager;
import com.jess.arms.utils.ArmsUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CommandImpl implements ICommand {

    private static final String TAG = CommandImpl.class.getSimpleName();

    private IPosAction mPosAction;

    public CommandImpl() {
    }

    public CommandImpl(IPosAction posAction) {
        this.mPosAction = posAction;
    }

    @Override
    public void onRequest(Context context, String request) {

        LoganManager.w_code(TAG, "onRequest : " + request);

        try {
            JSONObject msgObj = new JSONObject(request);
            String eventName = msgObj.getString(Constant.EVENT.ATTR.EVENT_NAME);
            if (Constant.EVENT.NAME.SALE.equals(eventName)) {
                startInitHywebActivity(context);
            } else if (Constant.EVENT.NAME.REFUND.equals(eventName)) {
                startInitHywebActivity(context);
            } else if (Constant.EVENT.NAME.VOID.equals(eventName)) {
                startInitHywebActivity(context);
            } else if (Constant.EVENT.NAME.GOTO.equals(eventName)) {
                startInitHywebActivity(context);
            }
        } catch (JSONException e) {
            startInitHywebActivity(context);
        }
    }

    private void startInitHywebActivity(Context context) {
        CC.obtainBuilder(ComponentName.COMPONENT_LOGIN)
                .setActionName(ComponentAction.Login.OPEN_WELCOME)
                .build()
                .call();
    }


    /**
     * 支付失败 {"EVENT_NAME":"SALE_RESP","STATUS":"09","TXN_ID":"20171205153245643043436585106024","TXN_AMT":1,"TIPS":0.00}
     * 支付成功 {"EVENT_NAME":"SALE_RESP","MID":"181500000260","PAYMENT_TYPE":"WCP","TRACE_NO":"20171205153245643043436585122154","RESP_CODE":"F0000","TIPS":0,"HOST_REF":"4200000136201805303582803320","TXN_TIME":"162530","TXN_DATE":"20181116","TXN_ID":"20171205153245643043436585122154","STATUS":"00","TID":"12189001","TXN_AMT":0.10}
     * 取消成功 {"EVENT_NAME":"VOID_RESP","STATUS":"00","PAYMENT_TYPE":"UP","RESP_CODE":"C1000","HOST_REF":"729706000007","TXN_TIME":"175305","TXN_ID":"PAY201911011747001513","TXN_DATE":"20191101"}
     */
    @Override
    public void onResponse(Context context, String response) {

        LoganManager.w_code(TAG, "onResponse : " + response);

        AppManager appManager = ArmsUtils.obtainAppComponentFromContext(context).appManager();
        //kill掉hyweb支付頁
        appManager.killActivity(CommandActivity.class);

        Activity currentActivity = appManager.getTopActivity();

        if (TextUtils.isEmpty(response)) {
            onPosException(new Exception(PayExceptionCode.pos_response_null));
            return;
        }

        try {
            JSONObject msgObj = new JSONObject(response);
            String eventName = msgObj.getString(Constant.EVENT.ATTR.EVENT_NAME);
            HywebPosResponse posResponse = parsePosResponse(response, eventName);
            if (posResponse != null) {
                if (PayStatusCode.withInvalid(posResponse.getSTATUS())) {
                    //調起POS失敗
                    onPosInvalid(PayStatusCode.getHywebRequestTextByCode(posResponse.getSTATUS()));
                } else {
                    //回調成功
                    onPosSuccess(context, posResponse, currentActivity);
                }
            } else {
                //回調異常
                onPosException(new Exception(PayExceptionCode.pos_response_101));
            }
        } catch (JSONException e) {
            e.printStackTrace();
            try {
                JSONObject msgObj = new JSONObject(response);
                String status = msgObj.getString("STATUS");
                if (PayStatusCode.withInvalid(status)) {
                    //調起POS失敗
                    onPosInvalid(PayStatusCode.getHywebRequestTextByCode(status));
                } else {
                    //回調異常
                    onPosException(new Exception(PayStatusCode.getHywebRequestTextByCode(status)));
                }
            } catch (JSONException ex) {
                ex.printStackTrace();
                //回調異常
                onPosException(e);
            }
        } finally {
            returnLastActivity(context, currentActivity);
        }
    }

    /**
     * 返回操作頁
     * @param context
     * @param currentActivity
     */
    private void returnLastActivity(Context context, Activity currentActivity) {
        if (currentActivity != null) {
            LoganManager.w_code(TAG, "currentActivity : " + currentActivity.getClass().getName());
            //返回上次操作的頁面
            Intent intent = new Intent();
            intent.setComponent(currentActivity.getComponentName());
            context.startActivity(intent);
        }
    }

    private HywebPosResponse parsePosResponse(String response, String eventName) {
        switch (eventName) {
            case com.etps.aca.lib.constant.Constant.EVENT.NAME.SALE_RESP:
                return GsonUtils.GsonToBean(response, SaleRespose.class);
            case com.etps.aca.lib.constant.Constant.EVENT.NAME.VOID_RESP:
                return GsonUtils.GsonToBean(response, VoidRespose.class);
            case com.etps.aca.lib.constant.Constant.EVENT.NAME.REFUND_RESP:
                return GsonUtils.GsonToBean(response, RefundRespose.class);
//                case com.etps.aca.lib.constant.Constant.EVENT.NAME.PRINT_RESP:
//                    return GsonUtils.GsonToBean(response, Printr.class);
            case com.etps.aca.lib.constant.Constant.EVENT.NAME.ADJUST_RESP:
                return GsonUtils.GsonToBean(response, AdjustTipRespose.class);
            case "RETRIEVAL_RESP":
                return GsonUtils.GsonToBean(response, RetrievalRespose.class);
            case "SETTLE_RESP":
                return GsonUtils.GsonToBean(response, SettlementRespose.class);
        }
        return null;
    }

    @Override
    public void onGoto(Context context) {
        LogUtil.d(TAG, "onGoto");
    }

    /**
     * 回調成功轉發到具體的實現類
     *
     * @param posResponse
     * @param actionActivity
     */
    private void onPosSuccess(Context context, HywebPosResponse posResponse, Activity actionActivity) {
        if (mPosAction != null) {
            mPosAction.onPosSuccess(context, posResponse, actionActivity);
        }
    }

    /**
     * 回調失敗轉發到具體的實現類
     *
     * @param e
     */
    public void onPosException(Exception e) {
        if (mPosAction != null) {
            mPosAction.onPosException(e);
        }
    }

    /**
     * 調起失敗轉發到具體的實現類
     *
     * @param e
     */
    public void onPosInvalid(String e) {
        if (mPosAction != null) {
            mPosAction.onPosInvalid(e);
        }
    }


}
