package com.gingersoft.gsa.cloud.pay.pos.hywebpos.constant;

import android.text.TextUtils;

/**
 * @作者: bin
 * @創建時間: 2020-12-24 9:41
 * @更新時間: 2020-12-24 9:41
 * @描述:
 */
public class PayStatusCode {

    /**
     * N5異常问题 :
     *
     * 1、N5 POS 機操作超時：當操作超時時，N5 POS 機將返回主畫面，並向 ECR 發送 Status Code“98”的響應消息。ECR 應將此筆交易視為失敗。
     * 2、N5 POS 機忙碌：當 ECR 向處於忙碌狀態的 N5 POS 機發送請求時，ECR 將收到 Status Code “97”的響應。在發送另一個請求之前，ECR 應該提示消息要求用戶完成 N5 POS 機中的當前 交易。
     * 3、N5 POS機應用程序崩潰處理：當ECR發現N5 POS機的某些響應遺失時（這可能是由於應用程 序崩潰）。ECR應該向N5 POS機發送交易查詢請求命令，以獲取交易結果。
     *
     */
    /**
     * 以下狀態認為是成功情況
     */
    public static final String PAY_STATUS_00 = "00"; //成功            √
    public static final String PAY_STATUS_02 = "02"; //微信、支付宝正在处理这笔退款请求（可认为已成功）  √
    /**
     * 以下狀態認為是无效情況
     */
    public static final String PAY_STATUS_09 = "09"; //用户取消        √
    public static final String PAY_STATUS_10 = "10"; //主持人拒绝      √
    public static final String PAY_STATUS_11 = "11"; //用户撤销（应用于仅限微信/支付宝）    √
    public static final String PAY_STATUS_12 = "12"; //交易有已经作废/已完成
    public static final String PAY_STATUS_13 = "13"; //找不到交易
    public static final String PAY_STATUS_90 = "90"; //通讯/格式 错误   √
    public static final String PAY_STATUS_91 = "91"; //功能或 付款方式没有 支持的    √
    public static final String PAY_STATUS_97 = "97"; //N5 POS忙碌           √

    /**
     * 以下狀態認為是異常情況
     */
    public static final String PAY_STATUS_03 = "03"; //确认/处理 (支付、清機 同步接口防止N5機器關機未收到結果)   √
    public static final String PAY_STATUS_98 = "98"; //超时           √
    public static final String PAY_STATUS_99 = "99"; //未知错误       √

    /**
     * 回調成功
     * @param status
     * @return
     */
    public static boolean withSuccess(String status) {
        if (TextUtils.isEmpty(status)) {
            return false;
        }
        //這二种狀態都可認為已成功
        if (status.equals(PAY_STATUS_00) || status.equals(PAY_STATUS_02)) {
            return true;
        }
        return false;
    }

    /**
     * 回調異常,比如突然斷網或關機沒有收到回調
     * @param status
     * @return
     */
    public static boolean withException(String status) {
        if (TextUtils.isEmpty(status)) {
            return true;
        }
        if (status.equals(PAY_STATUS_98) || status.equals(PAY_STATUS_99) || status.equals(PAY_STATUS_03)) {
            return true;
        }
        return false;
    }

    /**
     * 本次操作無效
     * @param status
     * @return
     */
    public static boolean withInvalid(String status){
        if(withSuccess(status) || withException(status)){
            return false;
        }
        return true;
    }

    public static String getHywebRequestTextByCode(String status) {
        switch (status) {
            case PAY_STATUS_00:
                return "成功";
            case PAY_STATUS_02:
                return "處理中";
            case PAY_STATUS_03:
                return "確認/處理";
            case PAY_STATUS_09:
                return "取消";
            case PAY_STATUS_10:
                return "主持人拒絕";
            case PAY_STATUS_11:
                return "撤銷";
            case PAY_STATUS_12:
                return "已作廢/已完成";
            case PAY_STATUS_13:
                return "找不到相關訂單";
            case PAY_STATUS_90:
                return "通訊/格式錯誤";
            case PAY_STATUS_91:
                return "功能或付款方式不支持";
            case PAY_STATUS_97:
                return "N5 POS忙碌,請先完成當前交易";
            case PAY_STATUS_98:
                return "超時";
            case PAY_STATUS_99:
                return "未知錯誤[100]";
        }
        return "未知錯誤[101]";
    }

    public static String getHywebRequestTextByCode(String status, String makeType) {
        switch (status) {
            case PAY_STATUS_00:
                return makeType + "成功";
            case PAY_STATUS_02:
                return makeType + "處理中";
            case PAY_STATUS_03:
                return makeType + "確認/處理";
            case PAY_STATUS_09:
                return makeType + "取消";
            case PAY_STATUS_10:
                return makeType + "主持人拒絕";
            case PAY_STATUS_11:
                return makeType + "撤銷";
            case PAY_STATUS_12:
                return makeType + "已作廢/已完成";
            case PAY_STATUS_13:
                return makeType + "找不到相關訂單";
            case PAY_STATUS_90:
                return makeType + "通訊/格式錯誤";
            case PAY_STATUS_91:
                return makeType + "功能或付款方式不支持";
            case PAY_STATUS_97:
                return makeType + "N5 POS忙碌,請先完成當前交易";
            case PAY_STATUS_98:
                return makeType + "超時";
            case PAY_STATUS_99:
                return makeType + "未知錯誤[100]";
        }
        return "未知錯誤[101]";
    }
}
