package com.gingersoft.supply_chain.mvp.server;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.supply_chain.mvp.bean.DishesResultBean;
import com.gingersoft.supply_chain.mvp.bean.FoodByCategoryResultBean;
import com.gingersoft.supply_chain.mvp.bean.FoodCategoryResultBean;
import com.gingersoft.supply_chain.mvp.bean.FoodListInfoBean;
import com.gingersoft.supply_chain.mvp.bean.MeasurementUnitBean;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;
import com.gingersoft.supply_chain.mvp.bean.PurchaseOrderResultBean;
import com.gingersoft.supply_chain.mvp.bean.SupplierResultBean;
import com.gingersoft.supply_chain.mvp.bean.WareHouseListBean;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.PartMap;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;
import retrofit2.http.QueryName;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/20
 * Time: 15:29
 * Use:
 */
public interface SupplierServer {
    /**
     * 新增供應商
     *
     * @param requestBody
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("supplier/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addSupplier(@Body RequestBody requestBody);

    /**
     * 獲取供應商列表
     *
     * @param map
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("supplier/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<SupplierResultBean> getSupplierList(@QueryMap Map<String, Object> map);

    /**
     * 修改供應商信息
     *
     * @param requestBody
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("supplier/update" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateSupplier(@Body RequestBody requestBody);

    /**
     * 供應商刪除
     *
     * @param id 供應商id
     */
    @FormUrlEncoded
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("supplier/delete" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> deleteSupplier(@Field("id") int id);


    /**
     * 獲取供應商信息
     *
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("supplier/name/get" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getSupplierInfo(@QueryMap Map<String, Object> map);

    /**
     * 獲取供應商聯繫方式
     *
     * @param supplierId
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("supplier/contact/get" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getSupplierContact(@Query("supplierId") String supplierId);

    /**
     * 獲取供應商聯繫方式
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("supplier/contact/update" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateSupplierContact(@Body RequestBody requestBody);

    /**
     * 批量新增供應商聯繫方式
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("/supplier/contact/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addSupplierContact(@Body RequestBody requestBody);

    /**
     * 獲取食品單位列表集合
     *
     * @param map
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("foodUnit/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<MeasurementUnitBean> getMeasurementUnitList(@QueryMap Map<String, Object> map);

    /**
     * 修改食品單位
     *
     * @param requestBody
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("foodUnit/update" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateFoodUnit(@Body RequestBody requestBody);

    /**
     * 獲取食品分類
     *
     * @param map
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("foodCategory/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<FoodCategoryResultBean> getFoodCategoryList(@QueryMap Map<String, Object> map);

    /**
     * 新增食品單位
     *
     * @param requestBody
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("foodUnit/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addFoodUnit(@Body RequestBody requestBody);

    /**
     * 新增分類
     *
     * @param requestBody
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("foodCategory/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addFoodCategory(@Body RequestBody requestBody);

    /**
     * 修改分類
     *
     * @param requestBody
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("foodCategory/update" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateFoodCategory(@Body RequestBody requestBody);

    /**
     * 刪除分類
     *
     * @param requestBody
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("foodCategory/delete" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> deleteFoodCategory(@Body RequestBody requestBody);

    /**
     * 上傳圖片
     *
     * @param parts
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @Multipart
    @POST("purchaseFood/image/upload" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> upLoadPic(@Part List<MultipartBody.Part> parts, @PartMap Map<String, Object> map);

    /**
     * 新增食品
     *
     * @param requestBody
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("purchaseFood/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addFood(@Body RequestBody requestBody);

    /**
     * 根據供應商獲取食品集合信息
     *
     * @param map
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("supplier/purchaseFood/get" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<FoodListInfoBean> getFoodIngredientsData(@QueryMap Map<String, Object> map);

    /**
     * 根據食材id獲取食材詳情
     *
     * @param map
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseFood/get" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getFoodIngredientsDetails(@QueryMap Map<String, Object> map);

    /**
     * 和上面的是同一個接口，返回數據不一致
     *
     * @param map
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("supplier/purchaseFood/get" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getFoodBySupplierId(@QueryMap Map<String, Object> map);

    /**
     * 修改食材信息
     *
     * @param requestBody
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("purchaseFood/update" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateFood(@Body RequestBody requestBody);

    /**
     * 刪除食材
     */
    @FormUrlEncoded
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("purchaseFood/delete" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> deleteFood(@Field("id") int id);

    /**
     * 獲取採購單列表
     *
     * @param map
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseOrder/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<PurchaseOrderResultBean> getOrderList(@QueryMap Map<String, Object> map);

    /**
     * 修改採購單信息
     *
     * @param requestBody
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("purchaseOrder/update" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateOrder(@Body RequestBody requestBody);

    /**
     * 修改採購單信息
     *
     * @param orderId 訂單id
     * @return
     */
    @FormUrlEncoded
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("purchaseOrder/delete" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> deleteOrder(@Field("id") int orderId);


    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseFood/warehousingEncodeSnIdList" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> querySnCodes(@Query("encodeFoodNo") String encodeFoodNo, @Query("encodeOrderNo") String encodeOrderNo);

    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseFood/deletesPurchaseFoodEncodeSn" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> deleteSnCode(@QueryMap Map<String, Object> map);

    /**
     * 再來一單，通過食材ids獲取詳細信息
     *
     * @param map
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseFood/batch/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> buyAgainByFoodIds(@QueryMap Map<String, Object> map);

    /**
     * 獲取下單頁面的分類結構
     *
     * @param map
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("foodCategory/tree/get" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<OrderCategoryBean> getCategoryTrees(@QueryMap Map<String, Object> map);

    /**
     * 新增採購訂單
     *
     * @param requestBody
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("purchaseOrder/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addNewPurchaseOrder(@Body RequestBody requestBody);

    /**
     * 獲取下單頁面的分類結構
     *
     * @param map
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("foodCategory/subset/get" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<FoodByCategoryResultBean> getFoodByCategory(@QueryMap Map<String, Object> map);

    /**
     * 獲取訂單生成後用於展示的鏈接
     *
     * @param orderId
     * @return
     */
    @FormUrlEncoded
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("purchaseOrder/upload" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getPurchaseOrderQrCode(@Field("orderId") String orderId);

    /**
     * 根據用戶選擇的類型發送消息
     *
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("purchaseOrderSend/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> sendMsg(@Body RequestBody requestBody);

    /**
     * 獲取訂單詳情
     *
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseOrder/get" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getOrderDetailsById(@Query("orderId") int orderId);


    /**
     * 添加入庫
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("purchaseOrder/warehousing/update" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addWarehouse(@Body RequestBody requestBody);

    /**
     * 獲取訂單列表
     *
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseWarehousingOrder/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getWareHouseList(@QueryMap Map<String, Object> map);


    /**
     * 獲取基本單位
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("basicUnitType/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getDeputyUnitList(@Query("brandId") int brandId, @Query("restaurantId") int restaurantId);

    /**
     * 批量修改副單位
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("foodUnit/set" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateDeputyUnitList(@Body RequestBody requestBody);

    /**
     * 批量修改副單位
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("foodUnit/update" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateDeputyUnit(@Body RequestBody requestBody);

    /**
     * 查詢庫存列表
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseWarehousingOrder/details/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<WareHouseListBean> getWarehousing(@QueryMap Map<String, Object> map);

    /**
     * 添加副單位快捷輸入
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("basicUnitType/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addDeputyUnitInput(@Body RequestBody requestBody);

    /**
     * 刪除副單位快捷輸入
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @FormUrlEncoded
    @POST("basicUnitType/delete" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> deleteUnitKey(@Field("id") int id);


    /**
     * 查詢入庫流水
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseWarehousingOrder/details/get" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getWarehousingDetails(@QueryMap Map<String, Object> map);

    /**
     * 查詢出庫流水
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseConsume/get/running/water" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getOutStockDetails(@QueryMap Map<String, Object> map);

    /**
     * 查詢出庫流水的出庫數量
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseFood/numberInventoryDetails" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getOutStockDetailsNumber(@QueryMap Map<String, Object> map);

    /**
     * 查詢庫存消耗原因
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseConsumeReason/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getWarehouseInventoryReason();

    /**
     * 庫存消耗
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("purchaseConsume/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> consumeWareHousing(@Body RequestBody requestBody);

    /**
     * 庫存盤點
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("purchaseConsume/addCheck" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> wareHousingInventory(@Body RequestBody requestBody);

    /**
     * 查詢庫存數量
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseConsume/get/remaining/quantity" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getWarehousingNum(@QueryMap Map<String, Object> map);

    /**
     * 查詢庫存的sn記錄
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseFood/foodEncodeDetailsSnList" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> queryInStockSnCodes(@Query("encodeFoodNo") String foodNo);

    /**
     * 查詢入庫流水或出庫流水的sn記錄
     *
     * @param map
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseFood/outboundInventoryEncodeSnIdList" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> querySnCodeList(@QueryMap Map<String, Object> map);

    /**
     * 查詢庫存消耗記錄
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseConsume/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getWarehousingRecord(@QueryMap Map<String, Object> map);


    /**
     * 查詢入庫原因
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseConsumeReason/multipleStorageCauseList" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getMultipleStorageCauseList(@QueryMap Map<String, Object> map);

    /**
     * 下入庫單
     * @param requestBody
     * @return
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @POST("purchaseWarehousingOrder/details/addMultipleStorageDetails"  + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addWarehousingOrder(@Body RequestBody requestBody);


    /**
     * 查詢入庫單列表
     * @param map
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseWarehousingOrder/details/getMultipleStorageOrder" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getWarehousingOrderList(@QueryMap Map<String, Object> map);


    /**
     * 查詢入庫單詳情
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseWarehousingOrder/details/getMultipleStorageOrderDetails" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getWarehousingOrderDetails(@Query("warehousingOrderId") int warehousingOrderId);

    /**
     * 根據SN碼查詢出入庫記錄
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseWarehousingOrder/details/getSnInventoryDetails" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getFoodInOutBoundRecordBySnCode(@QueryMap Map<String, Object> map);

    /**
     * 查詢出入庫詳情
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseWarehousingOrder/details/getFoodNoInventoryDetails" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getFoodInOutBoundRecordDetails(@QueryMap Map<String, Object> map);


    /**
     * 查询菜品
     * http://a.ricepon.com:58201/ricepon-purchase/api/
     * purchaseDishesConversion/getPurchaseDishesConversionDishes?
     * parentId=9615&restaurantId=25
     * isParent: 0
     */
    @Headers({"Domain-Name: ricepon-purchase"})
    @GET("purchaseDishesConversion/getPurchaseDishesConversionDishes" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<DishesResultBean> getFoodList(@QueryMap Map<String, Object> map);

}
