package com.gingersoft.supply_chain.mvp.presenter;

import android.app.Application;
import android.text.InputFilter;
import android.view.inputmethod.EditorInfo;

import com.gingersoft.gsa.cloud.ui.adapter.bean.InfoMultiBean;
import com.gingersoft.gsa.cloud.ui.adapter.bean.MultiInputSelectBean;
import com.gingersoft.supply_chain.mvp.bean.FoodPackingSpecificationBean;
import com.gingersoft.supply_chain.mvp.bean.MeasurementUnitBean;
import com.gingersoft.supply_chain.mvp.contract.PackageSpecificationContract;
import com.gingersoft.supply_chain.mvp.ui.fragment.food.MeasurementUnitFragment;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.http.imageloader.ImageLoader;
import com.jess.arms.integration.AppManager;
import com.jess.arms.mvp.BasePresenter;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;

import me.jessyan.rxerrorhandler.core.RxErrorHandler;

import static com.gingersoft.supply_chain.mvp.ui.fragment.food.PackageSpecificationFragment.OrderingUnitRequestCode;
import static com.gingersoft.supply_chain.mvp.ui.fragment.food.PackageSpecificationFragment.ReceivingUnitRequestCode;


/**
 * ================================================
 * Description:
 */
@FragmentScope
public class PackageSpecificationPresenter extends BasePresenter<PackageSpecificationContract.Model, PackageSpecificationContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    public int orderingUnitIndex = 2;
    public int receivingUnitIndex = 4;

    public MeasurementUnitBean.DataBean.Unit orderingUnit;
    public MeasurementUnitBean.DataBean.Unit receivingUnit;

    @Inject
    public PackageSpecificationPresenter(PackageSpecificationContract.Model model, PackageSpecificationContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public List<InfoMultiBean> getInfoMultiList() {
        List<InfoMultiBean> infoMultiBeans = new ArrayList<>();
        infoMultiBeans.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_LINE));
        infoMultiBeans.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_TITLE, "包裝規格"));
        infoMultiBeans.add(new MultiInputSelectBean(InfoMultiBean.ITEM_MULTIPLE_INPUT_SELECT, "訂貨單位", "最小數量", "最大數量", "單位", OrderingUnitRequestCode, MeasurementUnitFragment.newInstance(true), new InputFilter[]{new InputFilter.LengthFilter(11)}, EditorInfo.TYPE_CLASS_NUMBER));
        infoMultiBeans.add(new InfoMultiBean(InfoMultiBean.ITEM_TYPE_LINE));
        infoMultiBeans.add(new MultiInputSelectBean(InfoMultiBean.ITEM_MULTIPLE_INPUT_SELECT, "收貨單位", "最小數量", "最大數量", "單位", ReceivingUnitRequestCode, MeasurementUnitFragment.newInstance(true), new InputFilter[]{new InputFilter.LengthFilter(11)}, EditorInfo.TYPE_CLASS_NUMBER));
        return infoMultiBeans;
    }

    public void setOrderingUnit(List<InfoMultiBean> infoMultiBeans, MeasurementUnitBean.DataBean.Unit unit) {
        this.orderingUnit = unit;
        infoMultiBeans.get(orderingUnitIndex).setShowValueThird(unit.getUnitContent());
    }

    public void setReceivingUnit(List<InfoMultiBean> infoMultiBeans, MeasurementUnitBean.DataBean.Unit unit) {
        this.receivingUnit = unit;
        infoMultiBeans.get(receivingUnitIndex).setShowValueThird(unit.getUnitContent());
    }

    public List<FoodPackingSpecificationBean> getFoodPackingSpecifications(List<InfoMultiBean> infoMultiBeans) {
        List<FoodPackingSpecificationBean> foodPackingSpecificationBeans = new ArrayList<>();
        //訂貨單位最小價格
        FoodPackingSpecificationBean orderingUnitBean = new FoodPackingSpecificationBean();
        orderingUnitBean.setFoodUnitId(orderingUnit.getId());
//        orderingUnitBean.setType(FoodPackingSpecificationBean.ORDERING_TYPE);
        orderingUnitBean.setQuantityStarts(Double.parseDouble(getOrderingMinNum(infoMultiBeans)));
        orderingUnitBean.setQuantityEnd(Double.parseDouble(getOrderingMaxNum(infoMultiBeans)));
        orderingUnitBean.setTypeName(infoMultiBeans.get(orderingUnitIndex).getShowValueThird());
        foodPackingSpecificationBeans.add(orderingUnitBean);


        FoodPackingSpecificationBean receivingUnitBean = new FoodPackingSpecificationBean();
        receivingUnitBean.setFoodUnitId(receivingUnit.getId());
//        receivingUnitBean.setType(FoodPackingSpecificationBean.RECEIVING_TYPE);
        receivingUnitBean.setQuantityStarts(Double.parseDouble(getReceivingMinNum(infoMultiBeans)));
        receivingUnitBean.setQuantityEnd(Double.parseDouble(getReceivingMaxNum(infoMultiBeans)));
        receivingUnitBean.setTypeName(infoMultiBeans.get(receivingUnitIndex).getShowValueThird());
        foodPackingSpecificationBeans.add(receivingUnitBean);
        return foodPackingSpecificationBeans;
    }

    public String getOrderingMinNum(List<InfoMultiBean> infoMultiBeans) {
        return infoMultiBeans.get(orderingUnitIndex).getShowValue();
    }

    public String getOrderingMaxNum(List<InfoMultiBean> infoMultiBeans) {
        return infoMultiBeans.get(orderingUnitIndex).getShowValueSecond();
    }
    public String getReceivingMinNum(List<InfoMultiBean> infoMultiBeans) {
        return infoMultiBeans.get(receivingUnitIndex).getShowValue();
    }

    public String getReceivingMaxNum(List<InfoMultiBean> infoMultiBeans) {
        return infoMultiBeans.get(receivingUnitIndex).getShowValueSecond();
    }
}
