package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;
import android.view.View;

import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.PurchaseOrderDetailsBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/24
 * Time: 9:07
 * Use:
 */
public class OrderDetailsFoodAdapter extends BaseQuickAdapter<PurchaseOrderDetailsBean.PurchaseOrderDetailsInfoVosBean, BaseViewHolder> {

    private Context context;

    public OrderDetailsFoodAdapter(Context context, @Nullable List<PurchaseOrderDetailsBean.PurchaseOrderDetailsInfoVosBean> data) {
        super(R.layout.item_order_details_food, data);
        this.context = context;
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, PurchaseOrderDetailsBean.PurchaseOrderDetailsInfoVosBean item) {
        viewHolder.setText(R.id.tv_order_details_item_food_name, item.getName());
        viewHolder.setText(R.id.tv_order_details_item_purchasing_unit, item.getUnit_content());
        viewHolder.setText(R.id.tv_order_details_item_purchasing_unit_price, "$" + item.getFoodPrice());
        viewHolder.setText(R.id.tv_order_details_item_num, String.valueOf(item.getFoodQuantity()));
        //保存下來總價，用於計算所有食品的總價
        item.setTotalAmount(MoneyUtil.priceCalculation(item.getFoodPrice(), item.getFoodQuantity()));
        viewHolder.setText(R.id.tv_order_details_item_purchasing_total_amount, "$" + item.getTotalAmount());
        //入庫單價
        RecyclerView rvWarehouseUnit = viewHolder.getView(R.id.rv_warehouse_unit);
        if (item.getWareHouseBeans() != null) {
            rvWarehouseUnit.setVisibility(View.VISIBLE);
            rvWarehouseUnit.setLayoutManager(new GridLayoutManager(context, 3));
            WareHouseUnitAdapter wareHouseUnitAdapter = new WareHouseUnitAdapter(item.getWareHouseBeans());
            rvWarehouseUnit.setAdapter(wareHouseUnitAdapter);
        } else {
            rvWarehouseUnit.setVisibility(View.GONE);
        }
        viewHolder.setBackgroundResource(R.id.iv_order_details_item_food_select, item.isChecked() ? R.drawable.ic_checkbox_checked : R.drawable.ic_checkbox_uncheck);
    }

    private static class WareHouseUnitAdapter extends BaseQuickAdapter<PurchaseOrderDetailsBean.PurchaseOrderDetailsInfoVosBean.WareHouseBean, BaseViewHolder> {
        public WareHouseUnitAdapter(List<PurchaseOrderDetailsBean.PurchaseOrderDetailsInfoVosBean.WareHouseBean> wareHouseBeans) {
            super(R.layout.item_receiving_unit, wareHouseBeans);
        }

        @Override
        protected void convert(@NotNull BaseViewHolder viewHolder, PurchaseOrderDetailsBean.PurchaseOrderDetailsInfoVosBean.WareHouseBean wareHouseBean) {
            viewHolder.setText(R.id.tv_receiving_unit_title, wareHouseBean.getTitle());
            viewHolder.setText(R.id.ed_receiving_unit_value, wareHouseBean.getValue());
        }
    }
}
