package com.gingersoft.gsa.cloud.database.utils;//package com.gingersoft.gsa.cloud.database.utils;

import android.content.Context;
import android.util.Log;

import com.gingersoft.gsa.cloud.database.DaoManager;
import com.gingersoft.gsa.cloud.database.bean.PrintCurrencyBean;
import com.gingersoft.gsa.cloud.database.greendao.PrintCurrencyBeanDao;

import org.greenrobot.greendao.query.QueryBuilder;

import java.util.List;

/**
 * Created by Wyh on 2020/1/17.
 */
public class PrintCurrencyDaoUtils {

    private static final String TAG = PrintCurrencyDaoUtils.class.getSimpleName();
    private DaoManager mManager;

    public PrintCurrencyDaoUtils(Context context) {
        mManager = DaoManager.getInstance();
        mManager.init(context);
    }


    /**
     * 完成PrintCurrencyBean记录的插入，如果表未创建，先创建PrintCurrencyBean表
     *
     * @return
     */
    public boolean insertPrintCurrencyBean(PrintCurrencyBean printerDevice) {
        boolean flag = false;
        flag = mManager.getDaoSession().getPrintCurrencyBeanDao().insert(printerDevice) == -1 ? false : true;
        Log.i(TAG, "insert printerDevice :" + flag + "-->" + printerDevice.toString());
        return flag;
    }

    /**
     * 插入多条数据，在子线程操作
     *
     * @param printerDeviceList
     * @return
     */
    public boolean insertMultPrintCurrencyBean(final List<PrintCurrencyBean> printerDeviceList) {
        boolean flag = false;
        try {
            mManager.getDaoSession().runInTx(new Runnable() {
                @Override
                public void run() {
                    for (PrintCurrencyBean PrintCurrencyBean : printerDeviceList) {
                        mManager.getDaoSession().insertOrReplace(PrintCurrencyBean);
                    }
                }
            });
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 修改一条数据
     *
     * @param printerDevice
     * @return
     */
    public boolean updatePrintCurrencyBean(PrintCurrencyBean printerDevice) {
        boolean flag = false;
        try {
            mManager.getDaoSession().update(printerDevice);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除单条记录
     *
     * @param printerDevice
     * @return
     */
    public boolean deletePrintCurrencyBean(PrintCurrencyBean printerDevice) {
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().delete(printerDevice);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 删除所有记录
     *
     * @return
     */
    public boolean deleteAll() {
        boolean flag = false;
        try {
            //按照id删除
            mManager.getDaoSession().deleteAll(PrintCurrencyBean.class);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /**
     * 查询所有记录
     *
     * @return
     */
    public List<PrintCurrencyBean> queryAllPrintCurrencyBean() {
        return mManager.getDaoSession().loadAll(PrintCurrencyBean.class);
    }

    /**
     * 根据主键id查询记录
     *
     * @param key
     * @return
     */
    public PrintCurrencyBean queryPrintCurrencyBeanById(long key) {
        return mManager.getDaoSession().load(PrintCurrencyBean.class, key);
    }

    /**
     * 使用native sql进行查询操作
     */
    public List<PrintCurrencyBean> queryPrintCurrencyBeanByNativeSql(String sql, String[] conditions) {
        return mManager.getDaoSession().queryRaw(PrintCurrencyBean.class, sql, conditions);
    }

    /**
     * 使用queryBuilder进行查询
     *
     * @return
     */
    public List<PrintCurrencyBean> queryPrintCurrencyBeanByQueryBuilder(long PrintCurrencyBeanId) {
        QueryBuilder<PrintCurrencyBean> queryBuilder = mManager.getDaoSession().queryBuilder(PrintCurrencyBean.class);
        return queryBuilder.where(PrintCurrencyBeanDao.Properties.Id.eq(PrintCurrencyBeanId)).list();
    }

    public void closeConnection() {
        mManager.closeConnection();
    }

}
