package com.gingersoft.gsa.cloud.print.bean;

import android.os.Parcel;
import android.os.Parcelable;

import com.gingersoft.gsa.cloud.print.bean.base.PrintBillItem;
import com.gingersoft.gsa.cloud.print.bean.base.PrintFoodItem;

import java.util.List;

import lombok.Data;

/**
 * @author : bin
 * @create date: 2020-12-01
 * @update date: 2020-12-01
 * @description:外賣印單打印實體
 */
@Data
public class PrintTakeawayFormContent implements  PrintContent, Parcelable {

    private String brand;
    private String resturantName;
    /**
     * 2=外送
     * 其他=自取
     */
    private String orderType;
    /**
     * 支付類型:在線支付，貨到付款
     */
    private String payType;
    //送達時間
    private String deliveryTime;
    //單號
    private String orderNo;
    //訂單碼
    private String billNo;
    //取餐碼/訂單碼
    private String orderTakeFoodCode;
    //開單時間
    private String billingTime;
    //支付時間
    private String payTime;
    //備註
    private String remark;
    //訂單實體
    private List<PrintFoodItem> foodItemList;
    private List<PrintBillItem> billItemList;
//    private List<PrintPayTypeItem> printPayTypeItemList;
    //總金額
    private String totalAmountText;
    private String totalAmount;
    //支付金額
    private String payAmountText;
    private String payAmount;
    //會員積分信息
    private String memberName;
    private String memberNumber;
    private String memberPhone;
    private String memberOldPoints;
    private String memberAddPoints;
    private String memberNowPoints;
    //收貨信息
    private String adress;
    private String receiver;
    private String phone;
    //禮貌用語
    private String politeLanguage;
    //打印時間
    private String printTime;

    public PrintTakeawayFormContent() {
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.brand);
        dest.writeString(this.resturantName);
        dest.writeString(this.orderType);
        dest.writeString(this.payType);
        dest.writeString(this.deliveryTime);
        dest.writeString(this.orderNo);
        dest.writeString(this.billNo);
        dest.writeString(this.orderTakeFoodCode);
        dest.writeString(this.billingTime);
        dest.writeString(this.payTime);
        dest.writeString(this.remark);
        dest.writeTypedList(this.foodItemList);
        dest.writeTypedList(this.billItemList);
        dest.writeString(this.totalAmountText);
        dest.writeString(this.totalAmount);
        dest.writeString(this.payAmountText);
        dest.writeString(this.payAmount);
        dest.writeString(this.memberName);
        dest.writeString(this.memberNumber);
        dest.writeString(this.memberPhone);
        dest.writeString(this.memberOldPoints);
        dest.writeString(this.memberAddPoints);
        dest.writeString(this.memberNowPoints);
        dest.writeString(this.adress);
        dest.writeString(this.receiver);
        dest.writeString(this.phone);
        dest.writeString(this.politeLanguage);
        dest.writeString(this.printTime);
    }

    protected PrintTakeawayFormContent(Parcel in) {
        this.brand = in.readString();
        this.resturantName = in.readString();
        this.orderType = in.readString();
        this.payType = in.readString();
        this.deliveryTime = in.readString();
        this.orderNo = in.readString();
        this.billNo = in.readString();
        this.orderTakeFoodCode = in.readString();
        this.billingTime = in.readString();
        this.payTime = in.readString();
        this.remark = in.readString();
        this.foodItemList = in.createTypedArrayList(PrintFoodItem.CREATOR);
        this.billItemList = in.createTypedArrayList(PrintBillItem.CREATOR);
        this.totalAmountText = in.readString();
        this.totalAmount = in.readString();
        this.payAmountText = in.readString();
        this.payAmount = in.readString();
        this.memberName = in.readString();
        this.memberNumber = in.readString();
        this.memberPhone = in.readString();
        this.memberOldPoints = in.readString();
        this.memberAddPoints = in.readString();
        this.memberNowPoints = in.readString();
        this.adress = in.readString();
        this.receiver = in.readString();
        this.phone = in.readString();
        this.politeLanguage = in.readString();
        this.printTime = in.readString();
    }

    public static final Creator<PrintTakeawayFormContent> CREATOR = new Creator<PrintTakeawayFormContent>() {
        @Override
        public PrintTakeawayFormContent createFromParcel(Parcel source) {
            return new PrintTakeawayFormContent(source);
        }

        @Override
        public PrintTakeawayFormContent[] newArray(int size) {
            return new PrintTakeawayFormContent[size];
        }
    };
}
