package com.gingersoft.gsa.cloud.ui.utils;

import android.app.Dialog;
import android.content.Context;
import android.view.Gravity;
import android.view.View;
import android.view.WindowManager;
import android.widget.TextView;

import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.adapter.RadioListAdapter;
import com.jess.arms.utils.ArmsUtils;
import com.lxj.xpopup.XPopup;
import com.lxj.xpopup.impl.InputConfirmPopupView;
import com.lxj.xpopup.interfaces.OnCancelListener;

import java.util.List;

/**
 * app常用彈窗
 */
public class AppDialog {
    private static AppDialog appDialog;

    public static AppDialog getInstance() {
        if (appDialog == null) {
            appDialog = new AppDialog();
        }
        return appDialog;
    }


    public void showWaringDialog(Context context, String title, DialogOnClickListenter sureOnclickListener) {
        showWaringDialog(context, title, null, null, sureOnclickListener, null, true);
    }

    public void showWaringDialog(Context context, String title, boolean isDismiss, DialogOnClickListenter sureOnclickListener) {
        showWaringDialog(context, title, null, null, sureOnclickListener, null, isDismiss);
    }

    public void showWaringDialog(Context context, String title, boolean isDismiss, DialogOnClickListenter sureOnclickListener, DialogOnClickListenter cancelOnclickListener) {
        showWaringDialog(context, title, null, null, sureOnclickListener, cancelOnclickListener, isDismiss);
    }

    private void showWaringDialog(Context context, String title, String confimText, String cancelText, DialogOnClickListenter sureOnclickListener, DialogOnClickListenter cancelOnclickListener, boolean isDismiss) {
        new DialogUtils(context, R.layout.other_order_pause_orders) {
            @Override
            public void initLayout(ViewHepler hepler, Dialog dialog) {
                if (title != null) {
                    hepler.setText(R.id.tv_warning_title, title);
                }
                if (confimText != null) {
                    hepler.setText(R.id.tv_dialog_confirm, confimText);
                }
                if (sureOnclickListener != null) {
                    hepler.getView(R.id.tv_dialog_confirm).setOnClickListener(v -> {
                        sureOnclickListener.onclick(v, dialog);
                        if (isDismiss) {
                            dialog.dismiss();
                        }
                    });
                }
                if (cancelText != null) {
                    hepler.setText(R.id.tv_dialog_cancel, cancelText);
                }
                if (cancelOnclickListener != null) {
                    hepler.getView(R.id.tv_dialog_cancel).setOnClickListener(v -> cancelOnclickListener.onclick(v, dialog));
                } else {
                    hepler.getView(R.id.tv_dialog_cancel).setOnClickListener(v -> dialog.dismiss());
                }
            }
        }.show();
    }

    public void showSelectDialog(Context context, String title, int spanCount, RecyclerView.Adapter adapter, DialogOnClickListenter sureOnclickListenter) {
        new DialogUtils(context, R.layout.dialog_select_layout) {
            @Override
            public void initLayout(ViewHepler hepler, Dialog dialog) {
                hepler.setText(R.id.tv_title, title);
                hepler.setAdapter(R.id.rv_delivery, new GridLayoutManager(context, spanCount), adapter);
                hepler.setOnClickListenter(R.id.tv_delivery_confirm, v -> sureOnclickListenter.onclick(v, dialog));
                hepler.setOnClickListenter(R.id.tv_delivery_cancel, v -> sureOnclickListenter.onclick(v, dialog));
            }
        }
                .setWidth(WindowManager.LayoutParams.MATCH_PARENT)
                .setHeight((int) (ArmsUtils.getScreenHeidth(context) * 0.5))
                .setGravity(Gravity.BOTTOM)
                .show();
    }

    public void showSelectDialog(Context context, String title, List<String> list, int defaultCheck, onDialogSelectListener onDialogSelectListener) {
        RadioListAdapter radioListAdapter = new RadioListAdapter(list);
        radioListAdapter.setSelectIndex(defaultCheck);
        showSelectDialog(context, title, 1, radioListAdapter, (view, dialog) -> {
            if (onDialogSelectListener != null) {
                onDialogSelectListener.onclick(view, dialog, radioListAdapter.getSelectIndex());
            }
        });
    }

    /**
     * 藍色的提示框
     */
    public void showTipDialog(Context context, String title, DialogOnClickListenter sureOnclickListenter) {
        showTipDialog(context, title, context.getString(R.string.str_determine), context.getString(R.string.str_cancel), sureOnclickListenter, null);
    }

    public void showTipDialog(Context context, String title, String sureBtnText, String cancelBtnText, DialogOnClickListenter sureOnclickListener, DialogOnClickListenter onCancelListener) {
        new DialogUtils(context, R.layout.dialog_tip) {
            @Override
            public void initLayout(ViewHepler hepler, Dialog dialog) {
                if (title != null) {
                    hepler.setText(R.id.tv_warning_title, title);
                }
                hepler.getView(R.id.tv_dialog_cancel).setOnClickListener(v -> dialog.dismiss());
                ((TextView) hepler.getView(R.id.tv_dialog_confirm)).setText(sureBtnText);
                ((TextView) hepler.getView(R.id.tv_dialog_cancel)).setText(cancelBtnText);
                hepler.getView(R.id.tv_dialog_confirm).setOnClickListener(v -> {
                    if (sureOnclickListener != null) {
                        sureOnclickListener.onclick(v, dialog);
                    }
                });
                hepler.getView(R.id.tv_dialog_cancel).setOnClickListener(v -> {
                    if (onCancelListener != null) {
                        onCancelListener.onclick(v, dialog);
                    }
                });
            }
        }.show();
    }

    public void showListDialog(Context context, String[] data, onDialogSelectListener onSelectListener) {
        new XPopup.Builder(context)
                .dismissOnTouchOutside(true)
                .asBottomList(null, data, (position, text) -> onSelectListener.onclick(null, null, position)).show();
    }


    public void showEditDialog(Context context, CharSequence title, CharSequence content, CharSequence inputContent, CharSequence hint, OnInputConfirmListener confirmListener) {
        showEditDialog(context, title, content, inputContent, hint, confirmListener, R.layout.dialog_edit);
    }

    public void showEditDialog(Context context, CharSequence title, CharSequence content, CharSequence inputContent, CharSequence hint, OnInputConfirmListener confirmListener, int layoutId) {
        showEditDialog(context, title, content, inputContent, hint, confirmListener, null, layoutId);
    }

    public void showEditDialog(Context context, CharSequence title, CharSequence content, CharSequence inputContent, CharSequence hint, OnInputConfirmListener confirmListener, OnCancelListener cancelListener, int layoutId) {
        InputConfirmPopupView inputConfirmPopupView = new XPopup.Builder(context)
                .asInputConfirm(title, content, inputContent, hint, text -> {
                    if (confirmListener != null) {
                        confirmListener.onConfirm(text);
                    }
                }, cancelListener, layoutId);
        inputConfirmPopupView.show();
    }


    public interface DialogOnClickListenter {
        void onclick(View view, Dialog dialog);
    }

    public interface onDialogSelectListener {
        void onclick(View view, Dialog dialog, int position);
    }

    public interface OnInputConfirmListener {
        void onConfirm(String text);
    }
}
