package com.gingersoft.supply_chain.mvp.presenter;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.utils.CollectionUtils;
import com.gingersoft.gsa.cloud.common.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.ui.animator.CustomAnimation3;
import com.gingersoft.supply_chain.mvp.bean.ConsumeReasonBean;
import com.gingersoft.supply_chain.mvp.bean.WarehousingOrderListBean;
import com.gingersoft.supply_chain.mvp.content.PurchaseConstant;
import com.gingersoft.supply_chain.mvp.ui.adapter.ConsumptionReasonAdapter;
import com.gingersoft.supply_chain.mvp.ui.adapter.WarehousingOrderListAdapter;
import com.jess.arms.integration.AppManager;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.http.imageloader.ImageLoader;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;

import javax.inject.Inject;

import com.gingersoft.supply_chain.mvp.contract.WarehousingOrderListContract;
import com.jess.arms.utils.RxLifecycleUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/28/2021 19:21
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class WarehousingOrderListPresenter extends BasePresenter<WarehousingOrderListContract.Model, WarehousingOrderListContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    WarehousingOrderListAdapter warehousingOrderListAdapter;

    public int pageIndex = 0;

    @Inject
    public WarehousingOrderListPresenter(WarehousingOrderListContract.Model model, WarehousingOrderListContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void getWarehousingOrderList() {
        Map<String, Object> map = new HashMap<>(2);
        PurchaseConstant.addBrandId(map);
        PurchaseConstant.addRestaurantId(map);
        PurchaseConstant.addPageSize(map);
        PurchaseConstant.addPageIndex(map, pageIndex);
        mModel.getWarehousingOrderList(map)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(PurchaseConstant.GET_INFO_LOADING))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<BaseResult>(mErrorHandler) {
                    @Override
                    public void onNext(BaseResult baseResult) {
                        if (baseResult != null && baseResult.isSuccess()) {
                            WarehousingOrderListBean warehousingOrderListBean = GsonUtils.GsonToBean(baseResult.getData(), WarehousingOrderListBean.class);
                            if (warehousingOrderListBean == null) {
                                mRootView.showMessage("訂單數據獲取失敗，請稍候重試");
                                mRootView.killMyself();
                            } else {
                                if (warehousingOrderListAdapter == null) {
                                    warehousingOrderListAdapter = new WarehousingOrderListAdapter(warehousingOrderListBean.getPurchaseWarehousingOrdersVO());
                                    warehousingOrderListAdapter.setAdapterAnimation(new CustomAnimation3());
                                    mRootView.loadList(warehousingOrderListAdapter);
                                } else {
                                    if (pageIndex == 0) {
                                        warehousingOrderListAdapter.setList(warehousingOrderListBean.getPurchaseWarehousingOrdersVO());
                                    } else {
                                        warehousingOrderListAdapter.addData(warehousingOrderListBean.getPurchaseWarehousingOrdersVO());
                                        mRootView.finishLoad(CollectionUtils.isNullOrEmpty(warehousingOrderListBean.getPurchaseWarehousingOrdersVO()));
                                        return;
                                    }
                                }
                            }
                        } else if (baseResult != null && TextUtil.isNotEmptyOrNullOrUndefined(baseResult.getErrMsg())) {
                            mRootView.showMessage(baseResult.getErrMsg());
                        } else {
                            mRootView.showMessage(PurchaseConstant.GET_INFO_ERROR);
                        }
                        mRootView.finishLoad(false);
                    }
                });
    }
}
