package com.gingersoft.gsa.cloud.common.core.settlement;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.List;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-03-10
 * 修订历史：2020-03-10
 * 描述：
 */
@Data
public class SettlementReport implements Parcelable {

    /**
     * yesterdayTime : 2020-03-12 19:19:44
     * vo : {"prices":256,"scamount":0,"disamount":0,"payNum":0,"payamount":0,"tipnum":0,"tipsPrice":0,"totamount":256,"num":2,"person":7}
     * analysis : [{"typeName":"堂食","num":3,"amount":678},{"typeName":"已完成賬單","num":1,"amount":201},{"typeName":"未完成賬單","num":2,"amount":477},{"typeName":"本月累計營業額","num":0,"amount":678}]
     * restaurantOperation : {"id":11,"uid":297,"restaurantId":410,"type":1,"openTime":1583919880776,"operationTime":1583922285557,"createTime":1583922285557}
     * cash : [{"payName":"現金","payNum":2,"payAmount":256}]
     */
    private String yesterdayTime;
    private VoBean vo;
    private RestaurantOperationBean restaurantOperation;
    private List<AnalysisBean> analysis;
    private List<CashBean> cash;
    private String currentTime;
    private String startTime;

    public SettlementReport() {
    }

    @Data
    public static class VoBean implements Parcelable {
        /**
         * prices : 256
         * scamount : 0
         * disamount : 0
         * payNum : 0
         * payamount : 0
         * tipnum : 0
         * tipsPrice : 0
         * totamount : 256
         * deliverycharge : 0
         * num : 2
         * person : 7
         */

        private double prices;
        private double scamount;
        private double disamount;
        private int payNum;
        private double payamount;
        private int tipnum;
        private double tipsPrice;
        private double totamount;
        private double deliverycharge;
        private int num;
        private int person;

        public VoBean() {
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeDouble(this.prices);
            dest.writeDouble(this.scamount);
            dest.writeDouble(this.disamount);
            dest.writeInt(this.payNum);
            dest.writeDouble(this.payamount);
            dest.writeInt(this.tipnum);
            dest.writeDouble(this.tipsPrice);
            dest.writeDouble(this.totamount);
            dest.writeDouble(this.deliverycharge);
            dest.writeInt(this.num);
            dest.writeInt(this.person);
        }

        protected VoBean(Parcel in) {
            this.prices = in.readDouble();
            this.scamount = in.readDouble();
            this.disamount = in.readDouble();
            this.payNum = in.readInt();
            this.payamount = in.readDouble();
            this.tipnum = in.readInt();
            this.tipsPrice = in.readDouble();
            this.totamount = in.readDouble();
            this.deliverycharge = in.readDouble();
            this.num = in.readInt();
            this.person = in.readInt();
        }

        public static final Creator<VoBean> CREATOR = new Creator<VoBean>() {
            @Override
            public VoBean createFromParcel(Parcel source) {
                return new VoBean(source);
            }

            @Override
            public VoBean[] newArray(int size) {
                return new VoBean[size];
            }
        };
    }

    @Data
    public static class RestaurantOperationBean implements Parcelable {
        /**
         * id : 11
         * uid : 297
         * restaurantId : 410
         * type : 1
         * openTime : 1583919880776
         * operationTime : 1583922285557
         * createTime : 1583922285557
         */
        private int id;
        private int uid;
        private int restaurantId;
        private int type;
        private long openTime;
        private long operationTime;
        private long createTime;

        public RestaurantOperationBean() {
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.id);
            dest.writeInt(this.uid);
            dest.writeInt(this.restaurantId);
            dest.writeInt(this.type);
            dest.writeLong(this.openTime);
            dest.writeLong(this.operationTime);
            dest.writeLong(this.createTime);
        }

        protected RestaurantOperationBean(Parcel in) {
            this.id = in.readInt();
            this.uid = in.readInt();
            this.restaurantId = in.readInt();
            this.type = in.readInt();
            this.openTime = in.readLong();
            this.operationTime = in.readLong();
            this.createTime = in.readLong();
        }

        public static final Creator<RestaurantOperationBean> CREATOR = new Creator<RestaurantOperationBean>() {
            @Override
            public RestaurantOperationBean createFromParcel(Parcel source) {
                return new RestaurantOperationBean(source);
            }

            @Override
            public RestaurantOperationBean[] newArray(int size) {
                return new RestaurantOperationBean[size];
            }
        };
    }

    @Data
    public static class AnalysisBean implements Parcelable {
        /**
         * typeName : 堂食
         * num : 3
         * person : 2
         * amount : 678
         */
        private String typeName;
        private int num;
        private int person;
        private double amount;

        public AnalysisBean() {
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.typeName);
            dest.writeInt(this.num);
            dest.writeInt(this.person);
            dest.writeDouble(this.amount);
        }

        protected AnalysisBean(Parcel in) {
            this.typeName = in.readString();
            this.num = in.readInt();
            this.person = in.readInt();
            this.amount = in.readDouble();
        }

        public static final Creator<AnalysisBean> CREATOR = new Creator<AnalysisBean>() {
            @Override
            public AnalysisBean createFromParcel(Parcel source) {
                return new AnalysisBean(source);
            }

            @Override
            public AnalysisBean[] newArray(int size) {
                return new AnalysisBean[size];
            }
        };
    }

    @Data
    public static class CashBean implements Parcelable {
        /**
         * payName : 現金
         * payNum : 2
         * payAmount : 256
         * payType : 1001
         */
        private String payName;
        private int payNum;
        private double payAmount;
        private int payType;

        public CashBean() {
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.payName);
            dest.writeInt(this.payNum);
            dest.writeDouble(this.payAmount);
            dest.writeInt(this.payType);
        }

        protected CashBean(Parcel in) {
            this.payName = in.readString();
            this.payNum = in.readInt();
            this.payAmount = in.readDouble();
            this.payType = in.readInt();
        }

        public static final Creator<CashBean> CREATOR = new Creator<CashBean>() {
            @Override
            public CashBean createFromParcel(Parcel source) {
                return new CashBean(source);
            }

            @Override
            public CashBean[] newArray(int size) {
                return new CashBean[size];
            }
        };
    }


    public static final Creator<SettlementReport> CREATOR = new Creator<SettlementReport>() {
        @Override
        public SettlementReport createFromParcel(Parcel in) {
            return new SettlementReport(in);
        }

        @Override
        public SettlementReport[] newArray(int size) {
            return new SettlementReport[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.yesterdayTime);
        dest.writeParcelable(this.vo, flags);
        dest.writeParcelable(this.restaurantOperation, flags);
        dest.writeTypedList(this.analysis);
        dest.writeTypedList(this.cash);
        dest.writeString(this.currentTime);
        dest.writeString(this.startTime);
    }

    protected SettlementReport(Parcel in) {
        this.yesterdayTime = in.readString();
        this.vo = in.readParcelable(VoBean.class.getClassLoader());
        this.restaurantOperation = in.readParcelable(RestaurantOperationBean.class.getClassLoader());
        this.analysis = in.createTypedArrayList(AnalysisBean.CREATOR);
        this.cash = in.createTypedArrayList(CashBean.CREATOR);
        this.currentTime = in.readString();
        this.startTime = in.readString();
    }

}
