package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;

import com.gingersoft.gsa.cloud.base.utils.PrintUtils;
import com.gingersoft.gsa.cloud.base.utils.toast.ToastUtils;

import java.util.ArrayList;
import java.util.List;

import am.util.printer.PrintDataMaker;
import am.util.printer.PrinterUtils;
import am.util.printer.PrinterWriter;
import am.util.printer.PrinterWriter58mm;
import am.util.printer.PrinterWriter80mm;

/**
 * Created by Wyh on 2020/1/9.
 * 送單打印
 */
public class SendPrint implements PrintDataMaker {

    private Context mContext;
    private int parting = 255;//高度分割值，
    private int width; // 打印的圖片寬度,紙張寬度
    private int printType;
    public SendPrint(Context context, int parting, int width,int type) {
        this.mContext = context;
        this.parting = parting;
        this.width = width;
        this.printType = type;
    }

    @Override
    public List<byte[]> getPrintData(int type) {
        ArrayList<byte[]> data = new ArrayList<>();
        try {
            PrinterWriter printer;
            printer = type == PrinterWriter58mm.TYPE_58 ? new PrinterWriter58mm(parting, width) : new PrinterWriter80mm(parting, width);
            printer.setAlignCenter();

            data.add(printer.getDataAndReset());
//            //壓縮bitmap到指定大小
//            bitmap = ImageUtils.zoomDrawabe(bitmap, width, bitmap.getHeight());
//            ArrayList<byte[]> image1 = PrinterUtils.decodeBitmapToDataList(bitmap, parting);//bitmap转字节码
            List<Bitmap> bitmaps = PrintUtils.getPrintBitmap(mContext, printType, width);//根據打印類型獲得不同的bitmap
            if (bitmaps.size() <= 0) {
                ToastUtils.show(mContext, "打印失敗");
                return null;
            }
            for (int i = 0; i < bitmaps.size(); i++) {
                data.addAll(PrinterUtils.decodeBitmapToDataList(bitmaps.get(i), parting));
                printer.printLineFeed();
                printer.printLineFeed();
                printer.printLineFeed();
                printer.printLineFeed();
                printer.printLineFeed();
                printer.feedPaperCutPartial();
                data.add(printer.getDataAndClose());
            }
//            String bitmapPath = FileUtils.getExternalFilesDir(context, "Temp") + "tmp_qr.jpg";
//            if (QRCodeUtil.createQRImage(qr, 380, 380, null, bitmapPath)) {
//                ArrayList<byte[]> image2 = printer.getImageByte(bitmapPath);
//                data.addAll(image2);
//            } else {
//                ArrayList<byte[]> image2 = printer
//                        .getImageByte(context.getResources(), R.drawable.ic_printer_qr);
//                data.addAll(image2);
//            }

            return data;
        } catch (Exception e) {
            return new ArrayList<>();
        }
    }
}
