package com.gingersoft.gsa.cloud.database.greendao;

import java.util.List;
import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;
import org.greenrobot.greendao.query.Query;
import org.greenrobot.greendao.query.QueryBuilder;

import com.gingersoft.gsa.cloud.database.bean.Food;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "FOOD".
*/
public class FoodDao extends AbstractDao<Food, Long> {

    public static final String TABLENAME = "FOOD";

    /**
     * Properties of entity Food.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Dbid = new Property(0, Long.class, "dbid", true, "_id");
        public final static Property Id = new Property(1, Long.class, "id", false, "ID");
        public final static Property ParentId = new Property(2, Long.class, "parentId", false, "PARENT_ID");
        public final static Property RestaurantId = new Property(3, Long.class, "restaurantId", false, "RESTAURANT_ID");
        public final static Property IsParent = new Property(4, Byte.class, "isParent", false, "IS_PARENT");
        public final static Property SeqNo = new Property(5, Long.class, "seqNo", false, "SEQ_NO");
        public final static Property FoodName = new Property(6, String.class, "foodName", false, "FOOD_NAME");
        public final static Property FoodName1 = new Property(7, String.class, "foodName1", false, "FOOD_NAME1");
        public final static Property FoodName2 = new Property(8, String.class, "foodName2", false, "FOOD_NAME2");
        public final static Property Plu = new Property(9, String.class, "plu", false, "PLU");
        public final static Property PosFid = new Property(10, String.class, "posFid", false, "POS_FID");
        public final static Property FoodDesc = new Property(11, String.class, "foodDesc", false, "FOOD_DESC");
        public final static Property LimitAmount = new Property(12, Long.class, "limitAmount", false, "LIMIT_AMOUNT");
        public final static Property LimitType = new Property(13, Long.class, "limitType", false, "LIMIT_TYPE");
        public final static Property FoodSummary = new Property(14, Long.class, "foodSummary", false, "FOOD_SUMMARY");
        public final static Property Invisible = new Property(15, Long.class, "invisible", false, "INVISIBLE");
        public final static Property AutoMod = new Property(16, Byte.class, "autoMod", false, "AUTO_MOD");
        public final static Property Price = new Property(17, Double.class, "price", false, "PRICE");
        public final static Property MarketPrice = new Property(18, Double.class, "marketPrice", false, "MARKET_PRICE");
        public final static Property LunchboxPrice = new Property(19, Double.class, "lunchboxPrice", false, "LUNCHBOX_PRICE");
        public final static Property ImgUrlSmall = new Property(20, String.class, "imgUrlSmall", false, "IMG_URL_SMALL");
        public final static Property Imageurl = new Property(21, String.class, "imageurl", false, "IMAGEURL");
        public final static Property RiceponInvisible = new Property(22, Long.class, "riceponInvisible", false, "RICEPON_INVISIBLE");
        public final static Property Cost = new Property(23, Double.class, "cost", false, "COST");
        public final static Property StartDate = new Property(24, java.util.Date.class, "startDate", false, "START_DATE");
        public final static Property EndDate = new Property(25, java.util.Date.class, "endDate", false, "END_DATE");
        public final static Property Like = new Property(26, Long.class, "like", false, "LIKE");
        public final static Property TotalSold = new Property(27, Long.class, "totalSold", false, "TOTAL_SOLD");
        public final static Property IsSold = new Property(28, Long.class, "isSold", false, "IS_SOLD");
        public final static Property CreateBy = new Property(29, String.class, "createBy", false, "CREATE_BY");
        public final static Property CreateTime = new Property(30, java.util.Date.class, "createTime", false, "CREATE_TIME");
        public final static Property UpdateBy = new Property(31, String.class, "updateBy", false, "UPDATE_BY");
        public final static Property UpdateTime = new Property(32, java.util.Date.class, "updateTime", false, "UPDATE_TIME");
        public final static Property PeriodId = new Property(33, Long.class, "periodId", false, "PERIOD_ID");
        public final static Property AbleDiscount = new Property(34, Long.class, "ableDiscount", false, "ABLE_DISCOUNT");
        public final static Property Takeaway = new Property(35, Long.class, "takeaway", false, "TAKEAWAY");
        public final static Property BlueEdit = new Property(36, Long.class, "blueEdit", false, "BLUE_EDIT");
        public final static Property CartEdit = new Property(37, Long.class, "cartEdit", false, "CART_EDIT");
        public final static Property AutoMerge = new Property(38, Long.class, "autoMerge", false, "AUTO_MERGE");
        public final static Property PrintSeting = new Property(39, String.class, "printSeting", false, "PRINT_SETING");
        public final static Property IsPrintQueueCode = new Property(40, Long.class, "isPrintQueueCode", false, "IS_PRINT_QUEUE_CODE");
        public final static Property QueueHeadId = new Property(41, Long.class, "queueHeadId", false, "QUEUE_HEAD_ID");
        public final static Property Approve = new Property(42, Long.class, "approve", false, "APPROVE");
        public final static Property PrintFont = new Property(43, Long.class, "printFont", false, "PRINT_FONT");
        public final static Property AdvPrice = new Property(44, Long.class, "advPrice", false, "ADV_PRICE");
        public final static Property PrintToBill = new Property(45, Long.class, "printToBill", false, "PRINT_TO_BILL");
        public final static Property PointsAdd = new Property(46, Double.class, "pointsAdd", false, "POINTS_ADD");
        public final static Property PointsRatio = new Property(47, Long.class, "pointsRatio", false, "POINTS_RATIO");
        public final static Property PointsRedeem = new Property(48, Double.class, "pointsRedeem", false, "POINTS_REDEEM");
        public final static Property KtPrintMainItem = new Property(49, Long.class, "ktPrintMainItem", false, "KT_PRINT_MAIN_ITEM");
        public final static Property KtShowPrice = new Property(50, Long.class, "ktShowPrice", false, "KT_SHOW_PRICE");
        public final static Property PrintTo = new Property(51, Long.class, "printTo", false, "PRINT_TO");
        public final static Property ToPax = new Property(52, Long.class, "toPax", false, "TO_PAX");
        public final static Property FoodType = new Property(53, Long.class, "foodType", false, "FOOD_TYPE");
        public final static Property MajorMainId = new Property(54, Long.class, "majorMainId", false, "MAJOR_MAIN_ID");
        public final static Property DeptId = new Property(55, Long.class, "deptId", false, "DEPT_ID");
        public final static Property ServiceCharge = new Property(56, Byte.class, "serviceCharge", false, "SERVICE_CHARGE");
        public final static Property ColorId = new Property(57, Long.class, "colorId", false, "COLOR_ID");
        public final static Property Conditions = new Property(58, Long.class, "conditions", false, "CONDITIONS");
        public final static Property IsRt = new Property(59, Long.class, "isRt", false, "IS_RT");
        public final static Property Deletes = new Property(60, Long.class, "deletes", false, "DELETES");
        public final static Property IsTimingFood = new Property(61, Long.class, "isTimingFood", false, "IS_TIMING_FOOD");
        public final static Property MinLongTime = new Property(62, Long.class, "minLongTime", false, "MIN_LONG_TIME");
        public final static Property UnitTime = new Property(63, Long.class, "unitTime", false, "UNIT_TIME");
        public final static Property UnitPrice = new Property(64, Double.class, "unitPrice", false, "UNIT_PRICE");
        public final static Property FreeLongTime = new Property(65, Long.class, "freeLongTime", false, "FREE_LONG_TIME");
        public final static Property FreePeriodBegin = new Property(66, java.util.Date.class, "freePeriodBegin", false, "FREE_PERIOD_BEGIN");
        public final static Property IsStatistic = new Property(67, Long.class, "isStatistic", false, "IS_STATISTIC");
    }

    private Query<Food> combo_FoodsQuery;

    public FoodDao(DaoConfig config) {
        super(config);
    }
    
    public FoodDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"FOOD\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: dbid
                "\"ID\" INTEGER," + // 1: id
                "\"PARENT_ID\" INTEGER," + // 2: parentId
                "\"RESTAURANT_ID\" INTEGER," + // 3: restaurantId
                "\"IS_PARENT\" INTEGER," + // 4: isParent
                "\"SEQ_NO\" INTEGER," + // 5: seqNo
                "\"FOOD_NAME\" TEXT," + // 6: foodName
                "\"FOOD_NAME1\" TEXT," + // 7: foodName1
                "\"FOOD_NAME2\" TEXT," + // 8: foodName2
                "\"PLU\" TEXT," + // 9: plu
                "\"POS_FID\" TEXT," + // 10: posFid
                "\"FOOD_DESC\" TEXT," + // 11: foodDesc
                "\"LIMIT_AMOUNT\" INTEGER," + // 12: limitAmount
                "\"LIMIT_TYPE\" INTEGER," + // 13: limitType
                "\"FOOD_SUMMARY\" INTEGER," + // 14: foodSummary
                "\"INVISIBLE\" INTEGER," + // 15: invisible
                "\"AUTO_MOD\" INTEGER," + // 16: autoMod
                "\"PRICE\" REAL," + // 17: price
                "\"MARKET_PRICE\" REAL," + // 18: marketPrice
                "\"LUNCHBOX_PRICE\" REAL," + // 19: lunchboxPrice
                "\"IMG_URL_SMALL\" TEXT," + // 20: imgUrlSmall
                "\"IMAGEURL\" TEXT," + // 21: imageurl
                "\"RICEPON_INVISIBLE\" INTEGER," + // 22: riceponInvisible
                "\"COST\" REAL," + // 23: cost
                "\"START_DATE\" INTEGER," + // 24: startDate
                "\"END_DATE\" INTEGER," + // 25: endDate
                "\"LIKE\" INTEGER," + // 26: like
                "\"TOTAL_SOLD\" INTEGER," + // 27: totalSold
                "\"IS_SOLD\" INTEGER," + // 28: isSold
                "\"CREATE_BY\" TEXT," + // 29: createBy
                "\"CREATE_TIME\" INTEGER," + // 30: createTime
                "\"UPDATE_BY\" TEXT," + // 31: updateBy
                "\"UPDATE_TIME\" INTEGER," + // 32: updateTime
                "\"PERIOD_ID\" INTEGER," + // 33: periodId
                "\"ABLE_DISCOUNT\" INTEGER," + // 34: ableDiscount
                "\"TAKEAWAY\" INTEGER," + // 35: takeaway
                "\"BLUE_EDIT\" INTEGER," + // 36: blueEdit
                "\"CART_EDIT\" INTEGER," + // 37: cartEdit
                "\"AUTO_MERGE\" INTEGER," + // 38: autoMerge
                "\"PRINT_SETING\" TEXT," + // 39: printSeting
                "\"IS_PRINT_QUEUE_CODE\" INTEGER," + // 40: isPrintQueueCode
                "\"QUEUE_HEAD_ID\" INTEGER," + // 41: queueHeadId
                "\"APPROVE\" INTEGER," + // 42: approve
                "\"PRINT_FONT\" INTEGER," + // 43: printFont
                "\"ADV_PRICE\" INTEGER," + // 44: advPrice
                "\"PRINT_TO_BILL\" INTEGER," + // 45: printToBill
                "\"POINTS_ADD\" REAL," + // 46: pointsAdd
                "\"POINTS_RATIO\" INTEGER," + // 47: pointsRatio
                "\"POINTS_REDEEM\" REAL," + // 48: pointsRedeem
                "\"KT_PRINT_MAIN_ITEM\" INTEGER," + // 49: ktPrintMainItem
                "\"KT_SHOW_PRICE\" INTEGER," + // 50: ktShowPrice
                "\"PRINT_TO\" INTEGER," + // 51: printTo
                "\"TO_PAX\" INTEGER," + // 52: toPax
                "\"FOOD_TYPE\" INTEGER," + // 53: foodType
                "\"MAJOR_MAIN_ID\" INTEGER," + // 54: majorMainId
                "\"DEPT_ID\" INTEGER," + // 55: deptId
                "\"SERVICE_CHARGE\" INTEGER," + // 56: serviceCharge
                "\"COLOR_ID\" INTEGER," + // 57: colorId
                "\"CONDITIONS\" INTEGER," + // 58: conditions
                "\"IS_RT\" INTEGER," + // 59: isRt
                "\"DELETES\" INTEGER," + // 60: deletes
                "\"IS_TIMING_FOOD\" INTEGER," + // 61: isTimingFood
                "\"MIN_LONG_TIME\" INTEGER," + // 62: minLongTime
                "\"UNIT_TIME\" INTEGER," + // 63: unitTime
                "\"UNIT_PRICE\" REAL," + // 64: unitPrice
                "\"FREE_LONG_TIME\" INTEGER," + // 65: freeLongTime
                "\"FREE_PERIOD_BEGIN\" INTEGER," + // 66: freePeriodBegin
                "\"IS_STATISTIC\" INTEGER);"); // 67: isStatistic
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"FOOD\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, Food entity) {
        stmt.clearBindings();
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(1, dbid);
        }
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(2, id);
        }
 
        Long parentId = entity.getParentId();
        if (parentId != null) {
            stmt.bindLong(3, parentId);
        }
 
        Long restaurantId = entity.getRestaurantId();
        if (restaurantId != null) {
            stmt.bindLong(4, restaurantId);
        }
 
        Byte isParent = entity.getIsParent();
        if (isParent != null) {
            stmt.bindLong(5, isParent);
        }
 
        Long seqNo = entity.getSeqNo();
        if (seqNo != null) {
            stmt.bindLong(6, seqNo);
        }
 
        String foodName = entity.getFoodName();
        if (foodName != null) {
            stmt.bindString(7, foodName);
        }
 
        String foodName1 = entity.getFoodName1();
        if (foodName1 != null) {
            stmt.bindString(8, foodName1);
        }
 
        String foodName2 = entity.getFoodName2();
        if (foodName2 != null) {
            stmt.bindString(9, foodName2);
        }
 
        String plu = entity.getPlu();
        if (plu != null) {
            stmt.bindString(10, plu);
        }
 
        String posFid = entity.getPosFid();
        if (posFid != null) {
            stmt.bindString(11, posFid);
        }
 
        String foodDesc = entity.getFoodDesc();
        if (foodDesc != null) {
            stmt.bindString(12, foodDesc);
        }
 
        Long limitAmount = entity.getLimitAmount();
        if (limitAmount != null) {
            stmt.bindLong(13, limitAmount);
        }
 
        Long limitType = entity.getLimitType();
        if (limitType != null) {
            stmt.bindLong(14, limitType);
        }
 
        Long foodSummary = entity.getFoodSummary();
        if (foodSummary != null) {
            stmt.bindLong(15, foodSummary);
        }
 
        Long invisible = entity.getInvisible();
        if (invisible != null) {
            stmt.bindLong(16, invisible);
        }
 
        Byte autoMod = entity.getAutoMod();
        if (autoMod != null) {
            stmt.bindLong(17, autoMod);
        }
 
        Double price = entity.getPrice();
        if (price != null) {
            stmt.bindDouble(18, price);
        }
 
        Double marketPrice = entity.getMarketPrice();
        if (marketPrice != null) {
            stmt.bindDouble(19, marketPrice);
        }
 
        Double lunchboxPrice = entity.getLunchboxPrice();
        if (lunchboxPrice != null) {
            stmt.bindDouble(20, lunchboxPrice);
        }
 
        String imgUrlSmall = entity.getImgUrlSmall();
        if (imgUrlSmall != null) {
            stmt.bindString(21, imgUrlSmall);
        }
 
        String imageurl = entity.getImageurl();
        if (imageurl != null) {
            stmt.bindString(22, imageurl);
        }
 
        Long riceponInvisible = entity.getRiceponInvisible();
        if (riceponInvisible != null) {
            stmt.bindLong(23, riceponInvisible);
        }
 
        Double cost = entity.getCost();
        if (cost != null) {
            stmt.bindDouble(24, cost);
        }
 
        java.util.Date startDate = entity.getStartDate();
        if (startDate != null) {
            stmt.bindLong(25, startDate.getTime());
        }
 
        java.util.Date endDate = entity.getEndDate();
        if (endDate != null) {
            stmt.bindLong(26, endDate.getTime());
        }
 
        Long like = entity.getLike();
        if (like != null) {
            stmt.bindLong(27, like);
        }
 
        Long totalSold = entity.getTotalSold();
        if (totalSold != null) {
            stmt.bindLong(28, totalSold);
        }
 
        Long isSold = entity.getIsSold();
        if (isSold != null) {
            stmt.bindLong(29, isSold);
        }
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(30, createBy);
        }
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(31, createTime.getTime());
        }
 
        String updateBy = entity.getUpdateBy();
        if (updateBy != null) {
            stmt.bindString(32, updateBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(33, updateTime.getTime());
        }
 
        Long periodId = entity.getPeriodId();
        if (periodId != null) {
            stmt.bindLong(34, periodId);
        }
 
        Long ableDiscount = entity.getAbleDiscount();
        if (ableDiscount != null) {
            stmt.bindLong(35, ableDiscount);
        }
 
        Long takeaway = entity.getTakeaway();
        if (takeaway != null) {
            stmt.bindLong(36, takeaway);
        }
 
        Long blueEdit = entity.getBlueEdit();
        if (blueEdit != null) {
            stmt.bindLong(37, blueEdit);
        }
 
        Long cartEdit = entity.getCartEdit();
        if (cartEdit != null) {
            stmt.bindLong(38, cartEdit);
        }
 
        Long autoMerge = entity.getAutoMerge();
        if (autoMerge != null) {
            stmt.bindLong(39, autoMerge);
        }
 
        String printSeting = entity.getPrintSeting();
        if (printSeting != null) {
            stmt.bindString(40, printSeting);
        }
 
        Long isPrintQueueCode = entity.getIsPrintQueueCode();
        if (isPrintQueueCode != null) {
            stmt.bindLong(41, isPrintQueueCode);
        }
 
        Long queueHeadId = entity.getQueueHeadId();
        if (queueHeadId != null) {
            stmt.bindLong(42, queueHeadId);
        }
 
        Long approve = entity.getApprove();
        if (approve != null) {
            stmt.bindLong(43, approve);
        }
 
        Long printFont = entity.getPrintFont();
        if (printFont != null) {
            stmt.bindLong(44, printFont);
        }
 
        Long advPrice = entity.getAdvPrice();
        if (advPrice != null) {
            stmt.bindLong(45, advPrice);
        }
 
        Long printToBill = entity.getPrintToBill();
        if (printToBill != null) {
            stmt.bindLong(46, printToBill);
        }
 
        Double pointsAdd = entity.getPointsAdd();
        if (pointsAdd != null) {
            stmt.bindDouble(47, pointsAdd);
        }
 
        Long pointsRatio = entity.getPointsRatio();
        if (pointsRatio != null) {
            stmt.bindLong(48, pointsRatio);
        }
 
        Double pointsRedeem = entity.getPointsRedeem();
        if (pointsRedeem != null) {
            stmt.bindDouble(49, pointsRedeem);
        }
 
        Long ktPrintMainItem = entity.getKtPrintMainItem();
        if (ktPrintMainItem != null) {
            stmt.bindLong(50, ktPrintMainItem);
        }
 
        Long ktShowPrice = entity.getKtShowPrice();
        if (ktShowPrice != null) {
            stmt.bindLong(51, ktShowPrice);
        }
 
        Long printTo = entity.getPrintTo();
        if (printTo != null) {
            stmt.bindLong(52, printTo);
        }
 
        Long toPax = entity.getToPax();
        if (toPax != null) {
            stmt.bindLong(53, toPax);
        }
 
        Long foodType = entity.getFoodType();
        if (foodType != null) {
            stmt.bindLong(54, foodType);
        }
 
        Long majorMainId = entity.getMajorMainId();
        if (majorMainId != null) {
            stmt.bindLong(55, majorMainId);
        }
 
        Long deptId = entity.getDeptId();
        if (deptId != null) {
            stmt.bindLong(56, deptId);
        }
 
        Byte serviceCharge = entity.getServiceCharge();
        if (serviceCharge != null) {
            stmt.bindLong(57, serviceCharge);
        }
 
        Long colorId = entity.getColorId();
        if (colorId != null) {
            stmt.bindLong(58, colorId);
        }
 
        Long conditions = entity.getConditions();
        if (conditions != null) {
            stmt.bindLong(59, conditions);
        }
 
        Long isRt = entity.getIsRt();
        if (isRt != null) {
            stmt.bindLong(60, isRt);
        }
 
        Long deletes = entity.getDeletes();
        if (deletes != null) {
            stmt.bindLong(61, deletes);
        }
 
        Long isTimingFood = entity.getIsTimingFood();
        if (isTimingFood != null) {
            stmt.bindLong(62, isTimingFood);
        }
 
        Long minLongTime = entity.getMinLongTime();
        if (minLongTime != null) {
            stmt.bindLong(63, minLongTime);
        }
 
        Long unitTime = entity.getUnitTime();
        if (unitTime != null) {
            stmt.bindLong(64, unitTime);
        }
 
        Double unitPrice = entity.getUnitPrice();
        if (unitPrice != null) {
            stmt.bindDouble(65, unitPrice);
        }
 
        Long freeLongTime = entity.getFreeLongTime();
        if (freeLongTime != null) {
            stmt.bindLong(66, freeLongTime);
        }
 
        java.util.Date freePeriodBegin = entity.getFreePeriodBegin();
        if (freePeriodBegin != null) {
            stmt.bindLong(67, freePeriodBegin.getTime());
        }
 
        Long isStatistic = entity.getIsStatistic();
        if (isStatistic != null) {
            stmt.bindLong(68, isStatistic);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, Food entity) {
        stmt.clearBindings();
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(1, dbid);
        }
 
        Long id = entity.getId();
        if (id != null) {
            stmt.bindLong(2, id);
        }
 
        Long parentId = entity.getParentId();
        if (parentId != null) {
            stmt.bindLong(3, parentId);
        }
 
        Long restaurantId = entity.getRestaurantId();
        if (restaurantId != null) {
            stmt.bindLong(4, restaurantId);
        }
 
        Byte isParent = entity.getIsParent();
        if (isParent != null) {
            stmt.bindLong(5, isParent);
        }
 
        Long seqNo = entity.getSeqNo();
        if (seqNo != null) {
            stmt.bindLong(6, seqNo);
        }
 
        String foodName = entity.getFoodName();
        if (foodName != null) {
            stmt.bindString(7, foodName);
        }
 
        String foodName1 = entity.getFoodName1();
        if (foodName1 != null) {
            stmt.bindString(8, foodName1);
        }
 
        String foodName2 = entity.getFoodName2();
        if (foodName2 != null) {
            stmt.bindString(9, foodName2);
        }
 
        String plu = entity.getPlu();
        if (plu != null) {
            stmt.bindString(10, plu);
        }
 
        String posFid = entity.getPosFid();
        if (posFid != null) {
            stmt.bindString(11, posFid);
        }
 
        String foodDesc = entity.getFoodDesc();
        if (foodDesc != null) {
            stmt.bindString(12, foodDesc);
        }
 
        Long limitAmount = entity.getLimitAmount();
        if (limitAmount != null) {
            stmt.bindLong(13, limitAmount);
        }
 
        Long limitType = entity.getLimitType();
        if (limitType != null) {
            stmt.bindLong(14, limitType);
        }
 
        Long foodSummary = entity.getFoodSummary();
        if (foodSummary != null) {
            stmt.bindLong(15, foodSummary);
        }
 
        Long invisible = entity.getInvisible();
        if (invisible != null) {
            stmt.bindLong(16, invisible);
        }
 
        Byte autoMod = entity.getAutoMod();
        if (autoMod != null) {
            stmt.bindLong(17, autoMod);
        }
 
        Double price = entity.getPrice();
        if (price != null) {
            stmt.bindDouble(18, price);
        }
 
        Double marketPrice = entity.getMarketPrice();
        if (marketPrice != null) {
            stmt.bindDouble(19, marketPrice);
        }
 
        Double lunchboxPrice = entity.getLunchboxPrice();
        if (lunchboxPrice != null) {
            stmt.bindDouble(20, lunchboxPrice);
        }
 
        String imgUrlSmall = entity.getImgUrlSmall();
        if (imgUrlSmall != null) {
            stmt.bindString(21, imgUrlSmall);
        }
 
        String imageurl = entity.getImageurl();
        if (imageurl != null) {
            stmt.bindString(22, imageurl);
        }
 
        Long riceponInvisible = entity.getRiceponInvisible();
        if (riceponInvisible != null) {
            stmt.bindLong(23, riceponInvisible);
        }
 
        Double cost = entity.getCost();
        if (cost != null) {
            stmt.bindDouble(24, cost);
        }
 
        java.util.Date startDate = entity.getStartDate();
        if (startDate != null) {
            stmt.bindLong(25, startDate.getTime());
        }
 
        java.util.Date endDate = entity.getEndDate();
        if (endDate != null) {
            stmt.bindLong(26, endDate.getTime());
        }
 
        Long like = entity.getLike();
        if (like != null) {
            stmt.bindLong(27, like);
        }
 
        Long totalSold = entity.getTotalSold();
        if (totalSold != null) {
            stmt.bindLong(28, totalSold);
        }
 
        Long isSold = entity.getIsSold();
        if (isSold != null) {
            stmt.bindLong(29, isSold);
        }
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(30, createBy);
        }
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(31, createTime.getTime());
        }
 
        String updateBy = entity.getUpdateBy();
        if (updateBy != null) {
            stmt.bindString(32, updateBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(33, updateTime.getTime());
        }
 
        Long periodId = entity.getPeriodId();
        if (periodId != null) {
            stmt.bindLong(34, periodId);
        }
 
        Long ableDiscount = entity.getAbleDiscount();
        if (ableDiscount != null) {
            stmt.bindLong(35, ableDiscount);
        }
 
        Long takeaway = entity.getTakeaway();
        if (takeaway != null) {
            stmt.bindLong(36, takeaway);
        }
 
        Long blueEdit = entity.getBlueEdit();
        if (blueEdit != null) {
            stmt.bindLong(37, blueEdit);
        }
 
        Long cartEdit = entity.getCartEdit();
        if (cartEdit != null) {
            stmt.bindLong(38, cartEdit);
        }
 
        Long autoMerge = entity.getAutoMerge();
        if (autoMerge != null) {
            stmt.bindLong(39, autoMerge);
        }
 
        String printSeting = entity.getPrintSeting();
        if (printSeting != null) {
            stmt.bindString(40, printSeting);
        }
 
        Long isPrintQueueCode = entity.getIsPrintQueueCode();
        if (isPrintQueueCode != null) {
            stmt.bindLong(41, isPrintQueueCode);
        }
 
        Long queueHeadId = entity.getQueueHeadId();
        if (queueHeadId != null) {
            stmt.bindLong(42, queueHeadId);
        }
 
        Long approve = entity.getApprove();
        if (approve != null) {
            stmt.bindLong(43, approve);
        }
 
        Long printFont = entity.getPrintFont();
        if (printFont != null) {
            stmt.bindLong(44, printFont);
        }
 
        Long advPrice = entity.getAdvPrice();
        if (advPrice != null) {
            stmt.bindLong(45, advPrice);
        }
 
        Long printToBill = entity.getPrintToBill();
        if (printToBill != null) {
            stmt.bindLong(46, printToBill);
        }
 
        Double pointsAdd = entity.getPointsAdd();
        if (pointsAdd != null) {
            stmt.bindDouble(47, pointsAdd);
        }
 
        Long pointsRatio = entity.getPointsRatio();
        if (pointsRatio != null) {
            stmt.bindLong(48, pointsRatio);
        }
 
        Double pointsRedeem = entity.getPointsRedeem();
        if (pointsRedeem != null) {
            stmt.bindDouble(49, pointsRedeem);
        }
 
        Long ktPrintMainItem = entity.getKtPrintMainItem();
        if (ktPrintMainItem != null) {
            stmt.bindLong(50, ktPrintMainItem);
        }
 
        Long ktShowPrice = entity.getKtShowPrice();
        if (ktShowPrice != null) {
            stmt.bindLong(51, ktShowPrice);
        }
 
        Long printTo = entity.getPrintTo();
        if (printTo != null) {
            stmt.bindLong(52, printTo);
        }
 
        Long toPax = entity.getToPax();
        if (toPax != null) {
            stmt.bindLong(53, toPax);
        }
 
        Long foodType = entity.getFoodType();
        if (foodType != null) {
            stmt.bindLong(54, foodType);
        }
 
        Long majorMainId = entity.getMajorMainId();
        if (majorMainId != null) {
            stmt.bindLong(55, majorMainId);
        }
 
        Long deptId = entity.getDeptId();
        if (deptId != null) {
            stmt.bindLong(56, deptId);
        }
 
        Byte serviceCharge = entity.getServiceCharge();
        if (serviceCharge != null) {
            stmt.bindLong(57, serviceCharge);
        }
 
        Long colorId = entity.getColorId();
        if (colorId != null) {
            stmt.bindLong(58, colorId);
        }
 
        Long conditions = entity.getConditions();
        if (conditions != null) {
            stmt.bindLong(59, conditions);
        }
 
        Long isRt = entity.getIsRt();
        if (isRt != null) {
            stmt.bindLong(60, isRt);
        }
 
        Long deletes = entity.getDeletes();
        if (deletes != null) {
            stmt.bindLong(61, deletes);
        }
 
        Long isTimingFood = entity.getIsTimingFood();
        if (isTimingFood != null) {
            stmt.bindLong(62, isTimingFood);
        }
 
        Long minLongTime = entity.getMinLongTime();
        if (minLongTime != null) {
            stmt.bindLong(63, minLongTime);
        }
 
        Long unitTime = entity.getUnitTime();
        if (unitTime != null) {
            stmt.bindLong(64, unitTime);
        }
 
        Double unitPrice = entity.getUnitPrice();
        if (unitPrice != null) {
            stmt.bindDouble(65, unitPrice);
        }
 
        Long freeLongTime = entity.getFreeLongTime();
        if (freeLongTime != null) {
            stmt.bindLong(66, freeLongTime);
        }
 
        java.util.Date freePeriodBegin = entity.getFreePeriodBegin();
        if (freePeriodBegin != null) {
            stmt.bindLong(67, freePeriodBegin.getTime());
        }
 
        Long isStatistic = entity.getIsStatistic();
        if (isStatistic != null) {
            stmt.bindLong(68, isStatistic);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public Food readEntity(Cursor cursor, int offset) {
        Food entity = new Food( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // dbid
            cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1), // id
            cursor.isNull(offset + 2) ? null : cursor.getLong(offset + 2), // parentId
            cursor.isNull(offset + 3) ? null : cursor.getLong(offset + 3), // restaurantId
            cursor.isNull(offset + 4) ? null : (byte) cursor.getShort(offset + 4), // isParent
            cursor.isNull(offset + 5) ? null : cursor.getLong(offset + 5), // seqNo
            cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6), // foodName
            cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7), // foodName1
            cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8), // foodName2
            cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9), // plu
            cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10), // posFid
            cursor.isNull(offset + 11) ? null : cursor.getString(offset + 11), // foodDesc
            cursor.isNull(offset + 12) ? null : cursor.getLong(offset + 12), // limitAmount
            cursor.isNull(offset + 13) ? null : cursor.getLong(offset + 13), // limitType
            cursor.isNull(offset + 14) ? null : cursor.getLong(offset + 14), // foodSummary
            cursor.isNull(offset + 15) ? null : cursor.getLong(offset + 15), // invisible
            cursor.isNull(offset + 16) ? null : (byte) cursor.getShort(offset + 16), // autoMod
            cursor.isNull(offset + 17) ? null : cursor.getDouble(offset + 17), // price
            cursor.isNull(offset + 18) ? null : cursor.getDouble(offset + 18), // marketPrice
            cursor.isNull(offset + 19) ? null : cursor.getDouble(offset + 19), // lunchboxPrice
            cursor.isNull(offset + 20) ? null : cursor.getString(offset + 20), // imgUrlSmall
            cursor.isNull(offset + 21) ? null : cursor.getString(offset + 21), // imageurl
            cursor.isNull(offset + 22) ? null : cursor.getLong(offset + 22), // riceponInvisible
            cursor.isNull(offset + 23) ? null : cursor.getDouble(offset + 23), // cost
            cursor.isNull(offset + 24) ? null : new java.util.Date(cursor.getLong(offset + 24)), // startDate
            cursor.isNull(offset + 25) ? null : new java.util.Date(cursor.getLong(offset + 25)), // endDate
            cursor.isNull(offset + 26) ? null : cursor.getLong(offset + 26), // like
            cursor.isNull(offset + 27) ? null : cursor.getLong(offset + 27), // totalSold
            cursor.isNull(offset + 28) ? null : cursor.getLong(offset + 28), // isSold
            cursor.isNull(offset + 29) ? null : cursor.getString(offset + 29), // createBy
            cursor.isNull(offset + 30) ? null : new java.util.Date(cursor.getLong(offset + 30)), // createTime
            cursor.isNull(offset + 31) ? null : cursor.getString(offset + 31), // updateBy
            cursor.isNull(offset + 32) ? null : new java.util.Date(cursor.getLong(offset + 32)), // updateTime
            cursor.isNull(offset + 33) ? null : cursor.getLong(offset + 33), // periodId
            cursor.isNull(offset + 34) ? null : cursor.getLong(offset + 34), // ableDiscount
            cursor.isNull(offset + 35) ? null : cursor.getLong(offset + 35), // takeaway
            cursor.isNull(offset + 36) ? null : cursor.getLong(offset + 36), // blueEdit
            cursor.isNull(offset + 37) ? null : cursor.getLong(offset + 37), // cartEdit
            cursor.isNull(offset + 38) ? null : cursor.getLong(offset + 38), // autoMerge
            cursor.isNull(offset + 39) ? null : cursor.getString(offset + 39), // printSeting
            cursor.isNull(offset + 40) ? null : cursor.getLong(offset + 40), // isPrintQueueCode
            cursor.isNull(offset + 41) ? null : cursor.getLong(offset + 41), // queueHeadId
            cursor.isNull(offset + 42) ? null : cursor.getLong(offset + 42), // approve
            cursor.isNull(offset + 43) ? null : cursor.getLong(offset + 43), // printFont
            cursor.isNull(offset + 44) ? null : cursor.getLong(offset + 44), // advPrice
            cursor.isNull(offset + 45) ? null : cursor.getLong(offset + 45), // printToBill
            cursor.isNull(offset + 46) ? null : cursor.getDouble(offset + 46), // pointsAdd
            cursor.isNull(offset + 47) ? null : cursor.getLong(offset + 47), // pointsRatio
            cursor.isNull(offset + 48) ? null : cursor.getDouble(offset + 48), // pointsRedeem
            cursor.isNull(offset + 49) ? null : cursor.getLong(offset + 49), // ktPrintMainItem
            cursor.isNull(offset + 50) ? null : cursor.getLong(offset + 50), // ktShowPrice
            cursor.isNull(offset + 51) ? null : cursor.getLong(offset + 51), // printTo
            cursor.isNull(offset + 52) ? null : cursor.getLong(offset + 52), // toPax
            cursor.isNull(offset + 53) ? null : cursor.getLong(offset + 53), // foodType
            cursor.isNull(offset + 54) ? null : cursor.getLong(offset + 54), // majorMainId
            cursor.isNull(offset + 55) ? null : cursor.getLong(offset + 55), // deptId
            cursor.isNull(offset + 56) ? null : (byte) cursor.getShort(offset + 56), // serviceCharge
            cursor.isNull(offset + 57) ? null : cursor.getLong(offset + 57), // colorId
            cursor.isNull(offset + 58) ? null : cursor.getLong(offset + 58), // conditions
            cursor.isNull(offset + 59) ? null : cursor.getLong(offset + 59), // isRt
            cursor.isNull(offset + 60) ? null : cursor.getLong(offset + 60), // deletes
            cursor.isNull(offset + 61) ? null : cursor.getLong(offset + 61), // isTimingFood
            cursor.isNull(offset + 62) ? null : cursor.getLong(offset + 62), // minLongTime
            cursor.isNull(offset + 63) ? null : cursor.getLong(offset + 63), // unitTime
            cursor.isNull(offset + 64) ? null : cursor.getDouble(offset + 64), // unitPrice
            cursor.isNull(offset + 65) ? null : cursor.getLong(offset + 65), // freeLongTime
            cursor.isNull(offset + 66) ? null : new java.util.Date(cursor.getLong(offset + 66)), // freePeriodBegin
            cursor.isNull(offset + 67) ? null : cursor.getLong(offset + 67) // isStatistic
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, Food entity, int offset) {
        entity.setDbid(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setId(cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1));
        entity.setParentId(cursor.isNull(offset + 2) ? null : cursor.getLong(offset + 2));
        entity.setRestaurantId(cursor.isNull(offset + 3) ? null : cursor.getLong(offset + 3));
        entity.setIsParent(cursor.isNull(offset + 4) ? null : (byte) cursor.getShort(offset + 4));
        entity.setSeqNo(cursor.isNull(offset + 5) ? null : cursor.getLong(offset + 5));
        entity.setFoodName(cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
        entity.setFoodName1(cursor.isNull(offset + 7) ? null : cursor.getString(offset + 7));
        entity.setFoodName2(cursor.isNull(offset + 8) ? null : cursor.getString(offset + 8));
        entity.setPlu(cursor.isNull(offset + 9) ? null : cursor.getString(offset + 9));
        entity.setPosFid(cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10));
        entity.setFoodDesc(cursor.isNull(offset + 11) ? null : cursor.getString(offset + 11));
        entity.setLimitAmount(cursor.isNull(offset + 12) ? null : cursor.getLong(offset + 12));
        entity.setLimitType(cursor.isNull(offset + 13) ? null : cursor.getLong(offset + 13));
        entity.setFoodSummary(cursor.isNull(offset + 14) ? null : cursor.getLong(offset + 14));
        entity.setInvisible(cursor.isNull(offset + 15) ? null : cursor.getLong(offset + 15));
        entity.setAutoMod(cursor.isNull(offset + 16) ? null : (byte) cursor.getShort(offset + 16));
        entity.setPrice(cursor.isNull(offset + 17) ? null : cursor.getDouble(offset + 17));
        entity.setMarketPrice(cursor.isNull(offset + 18) ? null : cursor.getDouble(offset + 18));
        entity.setLunchboxPrice(cursor.isNull(offset + 19) ? null : cursor.getDouble(offset + 19));
        entity.setImgUrlSmall(cursor.isNull(offset + 20) ? null : cursor.getString(offset + 20));
        entity.setImageurl(cursor.isNull(offset + 21) ? null : cursor.getString(offset + 21));
        entity.setRiceponInvisible(cursor.isNull(offset + 22) ? null : cursor.getLong(offset + 22));
        entity.setCost(cursor.isNull(offset + 23) ? null : cursor.getDouble(offset + 23));
        entity.setStartDate(cursor.isNull(offset + 24) ? null : new java.util.Date(cursor.getLong(offset + 24)));
        entity.setEndDate(cursor.isNull(offset + 25) ? null : new java.util.Date(cursor.getLong(offset + 25)));
        entity.setLike(cursor.isNull(offset + 26) ? null : cursor.getLong(offset + 26));
        entity.setTotalSold(cursor.isNull(offset + 27) ? null : cursor.getLong(offset + 27));
        entity.setIsSold(cursor.isNull(offset + 28) ? null : cursor.getLong(offset + 28));
        entity.setCreateBy(cursor.isNull(offset + 29) ? null : cursor.getString(offset + 29));
        entity.setCreateTime(cursor.isNull(offset + 30) ? null : new java.util.Date(cursor.getLong(offset + 30)));
        entity.setUpdateBy(cursor.isNull(offset + 31) ? null : cursor.getString(offset + 31));
        entity.setUpdateTime(cursor.isNull(offset + 32) ? null : new java.util.Date(cursor.getLong(offset + 32)));
        entity.setPeriodId(cursor.isNull(offset + 33) ? null : cursor.getLong(offset + 33));
        entity.setAbleDiscount(cursor.isNull(offset + 34) ? null : cursor.getLong(offset + 34));
        entity.setTakeaway(cursor.isNull(offset + 35) ? null : cursor.getLong(offset + 35));
        entity.setBlueEdit(cursor.isNull(offset + 36) ? null : cursor.getLong(offset + 36));
        entity.setCartEdit(cursor.isNull(offset + 37) ? null : cursor.getLong(offset + 37));
        entity.setAutoMerge(cursor.isNull(offset + 38) ? null : cursor.getLong(offset + 38));
        entity.setPrintSeting(cursor.isNull(offset + 39) ? null : cursor.getString(offset + 39));
        entity.setIsPrintQueueCode(cursor.isNull(offset + 40) ? null : cursor.getLong(offset + 40));
        entity.setQueueHeadId(cursor.isNull(offset + 41) ? null : cursor.getLong(offset + 41));
        entity.setApprove(cursor.isNull(offset + 42) ? null : cursor.getLong(offset + 42));
        entity.setPrintFont(cursor.isNull(offset + 43) ? null : cursor.getLong(offset + 43));
        entity.setAdvPrice(cursor.isNull(offset + 44) ? null : cursor.getLong(offset + 44));
        entity.setPrintToBill(cursor.isNull(offset + 45) ? null : cursor.getLong(offset + 45));
        entity.setPointsAdd(cursor.isNull(offset + 46) ? null : cursor.getDouble(offset + 46));
        entity.setPointsRatio(cursor.isNull(offset + 47) ? null : cursor.getLong(offset + 47));
        entity.setPointsRedeem(cursor.isNull(offset + 48) ? null : cursor.getDouble(offset + 48));
        entity.setKtPrintMainItem(cursor.isNull(offset + 49) ? null : cursor.getLong(offset + 49));
        entity.setKtShowPrice(cursor.isNull(offset + 50) ? null : cursor.getLong(offset + 50));
        entity.setPrintTo(cursor.isNull(offset + 51) ? null : cursor.getLong(offset + 51));
        entity.setToPax(cursor.isNull(offset + 52) ? null : cursor.getLong(offset + 52));
        entity.setFoodType(cursor.isNull(offset + 53) ? null : cursor.getLong(offset + 53));
        entity.setMajorMainId(cursor.isNull(offset + 54) ? null : cursor.getLong(offset + 54));
        entity.setDeptId(cursor.isNull(offset + 55) ? null : cursor.getLong(offset + 55));
        entity.setServiceCharge(cursor.isNull(offset + 56) ? null : (byte) cursor.getShort(offset + 56));
        entity.setColorId(cursor.isNull(offset + 57) ? null : cursor.getLong(offset + 57));
        entity.setConditions(cursor.isNull(offset + 58) ? null : cursor.getLong(offset + 58));
        entity.setIsRt(cursor.isNull(offset + 59) ? null : cursor.getLong(offset + 59));
        entity.setDeletes(cursor.isNull(offset + 60) ? null : cursor.getLong(offset + 60));
        entity.setIsTimingFood(cursor.isNull(offset + 61) ? null : cursor.getLong(offset + 61));
        entity.setMinLongTime(cursor.isNull(offset + 62) ? null : cursor.getLong(offset + 62));
        entity.setUnitTime(cursor.isNull(offset + 63) ? null : cursor.getLong(offset + 63));
        entity.setUnitPrice(cursor.isNull(offset + 64) ? null : cursor.getDouble(offset + 64));
        entity.setFreeLongTime(cursor.isNull(offset + 65) ? null : cursor.getLong(offset + 65));
        entity.setFreePeriodBegin(cursor.isNull(offset + 66) ? null : new java.util.Date(cursor.getLong(offset + 66)));
        entity.setIsStatistic(cursor.isNull(offset + 67) ? null : cursor.getLong(offset + 67));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(Food entity, long rowId) {
        entity.setDbid(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(Food entity) {
        if(entity != null) {
            return entity.getDbid();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(Food entity) {
        return entity.getDbid() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
    /** Internal query to resolve the "foods" to-many relationship of Combo. */
    public List<Food> _queryCombo_Foods(Long id) {
        synchronized (this) {
            if (combo_FoodsQuery == null) {
                QueryBuilder<Food> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.Id.eq(null));
                combo_FoodsQuery = queryBuilder.build();
            }
        }
        Query<Food> query = combo_FoodsQuery.forCurrentThread();
        query.setParameter(0, id);
        return query.list();
    }

}
