package com.gingersoft.gsa.cloud.user.login.mvp.presenter;

import android.app.Application;
import android.util.Log;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.ui.bean.mode.LoginBean;
import com.jess.arms.integration.AppManager;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.http.imageloader.ImageLoader;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.schedulers.Schedulers;
import me.jessyan.rxerrorhandler.core.RxErrorHandler;
import me.jessyan.rxerrorhandler.handler.ErrorHandleSubscriber;
import okhttp3.FormBody;
import okhttp3.RequestBody;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.user.login.mvp.contract.LoginContract;
import com.jess.arms.utils.RxLifecycleUtils;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/21/2019 16:23
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class LoginPresenter extends BasePresenter<LoginContract.Model, LoginContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    @Inject
    public LoginPresenter(LoginContract.Model model, LoginContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }


    public void login(String account, String pwd) {
        RequestBody requestBody;

        if (account.equals("")) {
            requestBody = new FormBody.Builder()
                    .add("userName", "admin")
                    .add("passWord", "123456")
                    .build();
//            requestBody = new FormBody.Builder()
//                    .add("userName", "19901001")
//                    .add("passWord", "123456")
//                    .build();
        } else {
            requestBody = new FormBody.Builder()
                    .add("userName", account.trim() + "")
                    .add("passWord", pwd.trim() + "")
                    .build();
        }

        mModel.login(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<LoginBean>(mErrorHandler) {

                    @Override
                    public void onNext(@NonNull LoginBean info) {
                        if (info != null && info.isSuccess()) {
                            GsaCloudApplication.isLogin = true;
                            GsaCloudApplication.userName = info.getData().getUser().getUserName();
                            mRootView.showMessage("登陸成功");
                            mRootView.loginSuccess(info);
                        } else {
                            GsaCloudApplication.isLogin = false;
                            mRootView.showMessage(info.getErrMsg());
                        }
                    }
                });
    }

    public void loginOut() {

        RequestBody requestBody = new FormBody.Builder()
                .add("userName", "")
                .add("passWord", "")
                .build();

        mModel.loginOut(requestBody)
                .subscribeOn(Schedulers.io())
                .doOnSubscribe(disposable -> mRootView.showLoading(""))
                .subscribeOn(AndroidSchedulers.mainThread())
                .observeOn(AndroidSchedulers.mainThread())
                .doAfterTerminate(() -> mRootView.hideLoading())
                .compose(RxLifecycleUtils.bindToLifecycle(mRootView))
                .subscribe(new ErrorHandleSubscriber<Object>(mErrorHandler) {
                    @Override
                    public void onNext(@NonNull Object info) {
                        GsaCloudApplication.isLogin = false;
                        mRootView.loginOut();
                    }
                });

    }
}
