package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.widget.LinearLayout;

import com.gingersoft.gsa.cloud.common.constans.ExpandConstant;
import com.gingersoft.gsa.cloud.common.core.delivery.OrderDetails;
import com.gingersoft.gsa.cloud.common.core.restaurant.utils.RestaurantExpandInfoUtils;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.order.order.TakeawayOrder;
import com.gingersoft.gsa.cloud.print.bean.PrintTakeawayFormContent;
import com.gingersoft.gsa.cloud.print.bean.base.PrintBillItem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 外送接單，印單   已改新版
 */
public class PrintOtherOrder extends PrinterRoot<PrintTakeawayFormContent> {

    private PrintTakeawayFormContent printTakeawayFormContent;

    @Override
    protected void setPrintContent(PrintTakeawayFormContent printContent) {
        this.printTakeawayFormContent = printContent;
    }

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        OrderDetails.DataBean dataBean = TakeawayOrder.getInstance().getShoppingCart().getDeliveryAndPickupData();
        if (dataBean != null) {
            Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
            //廚房單，可能會有多個IP打印
            //獲得ip打印列表，
            //再將食品數據根據打印位置分組。
            //打印一組之後，關閉連接，切換第二台打印機ip，如此循環
            //打印完成之後，返回所有打印結果。
            //如果需要打印印單，加上
            List<Bitmap> bitmaps = new ArrayList<>();
            Bitmap bitmap = getBitmap(mContext, dataBean, deviceBean);
            bitmaps.add(bitmap);
            merge2ResultMap(bitmapMaps, "", bitmaps);
            return bitmapMaps;
        }
        return null;
    }

    @Override
    public String[] getPrintDatas(Context mContext, PrinterDeviceBean deviceBean) {

        if (printTakeawayFormContent == null) {
            return new String[]{"<html><body></body></html>"};
        }
        String stringBuilder = "<html><body>" +
                getTakewayPrintContent(printTakeawayFormContent,deviceBean) +
                "</body></html>";
        int printCount = getPrintCount(mContext);
        String[] pritContent = new String[printCount];
        for (int i = 0; i < printCount; i++) {
            pritContent[i] = stringBuilder;
        }
        return pritContent;
    }

    @Override
    public int getPrintCount(Context context) {
        return RestaurantExpandInfoUtils.getValue(ExpandConstant.DeliveryPrintCount,1);
    }

    private Bitmap getBitmap(Context mContext, OrderDetails.DataBean data, PrinterDeviceBean deviceBean) {
        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);
        //頭部
        layout.addView(getHeader(mContext));
        //訂單信息
        layout.addView(getTakeawayOrderInfo(mContext, data));
        //食品
        layout.addView(getTextLine(mContext, "項目"));
        layout.addView(getDiningFoodList(mContext, orderDetailCastPrintFoodItem(OrderDetail.productMameBeanToOrderDetail(0, data.getPRODUCT_NAME())), deviceBean, 1, true));
        layout.addView(getLine(mContext));
        //訂單金額信息
        List<PrintBillItem> billData = new ArrayList<>();
        billData.add(getBillBean("合計：", MONETARY_UNIT + MoneyUtil.sub(MoneyUtil.sub(Double.parseDouble(data.getTOTAL_AMOUNT()), data.getLunchbox()), data.getDELIVERY_CHARGE())));
        if (data.getLunchbox() != 0) {
            billData.add(getBillBean("餐盒費：", MONETARY_UNIT + data.getLunchbox()));
        }
        if (data.getDELIVERY_CHARGE() != 0) {
            billData.add(getBillBean("送貨費：", MONETARY_UNIT + data.getDELIVERY_CHARGE()));
        }
        billData.add(getBillBean("總金額：", MONETARY_UNIT + data.getTOTAL_AMOUNT()));
        double totalAmount = Double.parseDouble(data.getTOTAL_AMOUNT());
        if (data.getCouponList() != null && data.getCouponList().size() > 0) {
            for (OrderDetails.DataBean.CouponBean coupon : data.getCouponList()) {
                billData.add(getBillBean(coupon.getCouponName() + "：", "-" + MONETARY_UNIT + coupon.getDiscount_amount()));
                totalAmount = MoneyUtil.sub(totalAmount, coupon.getDiscount_amount());
            }
        }
        layout.addView(getTakeawayBillInfoView(mContext, billData));
        layout.addView(getLine(mContext));
        //總金額34sp
//        layout.addView(getTakeawayLargeAmount(mContext, "總金額：", MONETARY_UNIT + data.getTOTAL_AMOUNT()));
//        layout.addView(getLine(mContext));
        //支付信息
        addTakeawayPayViews(mContext, layout, data.getPayMultiple(), totalAmount);
        //用戶信息
        getTakeawayReceiver(mContext, data, layout);
        //尾部
        return viewToZoomBitmap(mContext, layout, deviceBean);
    }

    private PrintBillItem getBillBean(String title, String value) {
        return new PrintBillItem(title, value);
    }

}
