package com.gingersoft.gsa.cloud.table.di.module;

import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;

import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.order.billItem.BillItem;
import com.gingersoft.gsa.cloud.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.table.mvp.contract.MealStandContract;
import com.gingersoft.gsa.cloud.table.mvp.contract.SetMealContract;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.SoldoutCtrFood;
import com.gingersoft.gsa.cloud.table.mvp.presenter.mealstand.SetMealPresenter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.BillItemAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.ComboAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.FoodAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.FoodGroupAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.ModifierAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.SelectMealAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.SelectMealAdapter2;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.di.scope.FragmentScope;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;

import com.gingersoft.gsa.cloud.table.mvp.contract.SetMealContract;
import com.gingersoft.gsa.cloud.table.mvp.model.SetMealModel;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.mvp.IView;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Inject;
import javax.inject.Named;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/17/2021 10:40
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@Module
public abstract class SetMealModule {

    @Binds
    abstract SetMealContract.Model bindSetMealModel(SetMealModel model);

//    @FragmentScope
//    @Provides
//    static List<OrderDetail> provideOrderMealList() {
//        return new ArrayList<>();
//    }
//
//    @FragmentScope
//    @Provides
//    static List<BillItem> provideBillItemList() {
//        return new ArrayList<>();
//    }

    @FragmentScope
    @Provides
    @Named("foodGroupList")
    static List<Food> provideFoodGroupList() {
        return new ArrayList<>();
    }

    @FragmentScope
    @Provides
    @Named("foodList")
    static List<Food> provideFoodList() {
        return new ArrayList<>();
    }

    @FragmentScope
    @Provides
    static List<ComboItem> provideFoodCombo() {
        return new ArrayList<>();
    }

    @FragmentScope
    @Provides
    static List<Modifier> provideModifierList() {
        return new ArrayList<>();
    }

    @FragmentScope
    @Provides
    @Named("fineTabTitles")
    static List<String> provideFineTabTitleList() {
        return new ArrayList<>();
    }

    @FragmentScope
    @Provides
    static List<SoldoutCtrFood> provideSoldoutCtrList() {
        return new ArrayList<>();
    }

//    @FragmentScope
//    @Provides
//    static SelectMealAdapter2 provideSelectMealAdapter2(SetMealContract.View IView, List<OrderDetail> orderMealList, BasePresenter presenter) {
//        return new SelectMealAdapter2(IView.getActivity2(), orderMealList,presenter);
//    }
//
//    @FragmentScope
//    @Provides
//    static BillItemAdapter provideBillItemAdapter(SetMealContract.View IView, List<BillItem> billItems) {
//        return new BillItemAdapter(IView.getActivity2(), billItems,"$");
//    }

    @FragmentScope
    @Provides
    static FoodGroupAdapter provideFoodGroupAdapter(SetMealContract.View IView, @Named("foodGroupList") List<Food> foodGroupList) {
        return new FoodGroupAdapter(IView.getActivity2(), foodGroupList, IView.getFromType());
    }

    @FragmentScope
    @Provides
    static FoodAdapter provideFoodAdapter(SetMealContract.View IView, @Named("foodList") List<Food> foodList) {
        return new FoodAdapter(IView.getActivity2(), foodList, IView.getFromType());
    }

    @FragmentScope
    @Provides
    static ComboAdapter provideComboAdapter(SetMealContract.View IView, List<ComboItem> comboItemList) {
        return new ComboAdapter(IView.getActivity2(), comboItemList);
    }

    @FragmentScope
    @Provides
    static ModifierAdapter provideModifierAdapter(SetMealContract.View IView, List<Modifier> modifierList) {
        return new ModifierAdapter(IView.getActivity2(), modifierList);
    }

    @FragmentScope
    @Provides
    @Named("foodGridLayoutManager")
    static GridLayoutManager provideFoodRecycleLayoutManager(SetMealContract.View IView) {
        return new GridLayoutManager(IView.getActivity2(), 1, LinearLayoutManager.HORIZONTAL, false);
    }

    @FragmentScope
    @Provides
    @Named("comboGridLayoutManager")
    static GridLayoutManager provideComboRecycleLayoutManager(SetMealContract.View IView) {
        return new GridLayoutManager(IView.getActivity2(), 1, LinearLayoutManager.HORIZONTAL, false);
    }

    @FragmentScope
    @Provides
    @Named("modifierGridLayoutManager")
    static GridLayoutManager provideModifierRecycleLayoutManager(SetMealContract.View IView) {
        return new GridLayoutManager(IView.getActivity2(), 1, LinearLayoutManager.HORIZONTAL, false);
    }


}