package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.order.bean.discount.MemberWalletCoupon;
import com.gingersoft.gsa.cloud.common.utils.gson.GsonUtils;
import com.gingersoft.gsa.cloud.table.mvp.model.service.MemberService;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.FragmentScope;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.table.mvp.contract.CouponContract;

import java.util.ArrayList;
import java.util.List;

import io.reactivex.Single;
import io.reactivex.functions.Function;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/02/2021 17:28
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class CouponModel extends BaseModel implements CouponContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public CouponModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Single<List<MemberWalletCoupon>> getMemberWalletList(int brandId, long memberId, long limitType, long pageIndex, long pageSize) {
        return mRepositoryManager.obtainRetrofitService(MemberService.class)
                .getMemberWalletList(brandId, memberId, limitType, pageIndex, pageSize)
                .map(new Function<BaseResult, List<MemberWalletCoupon>>() {
                    @Override
                    public List<MemberWalletCoupon> apply(BaseResult result) throws Exception {
                        if (result.isSuccess()) {
                            return GsonUtils.jsonToList(result.getData(), MemberWalletCoupon.class);
                        } else {
                            return new ArrayList<>();
                        }
                    }
                });
    }



}