package com.gingersoft.gsa.cloud.table.mvp.model.service;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;

import io.reactivex.Observable;
import io.reactivex.Single;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.Query;

/**
 * Created by Wyh on 2020/1/17.
 */
public interface MemberService {


    @Headers({"Domain-Name: new_base_url"})
    @GET("member/checkMemberInfo" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> queryMember(@Query("type") int type, @Query("parm")  String  parm, @Query("gsposShopId") String shopName,@Query("tableId") int tableId, @Query("tableNumber")  String  tableNumber);

    @GET("restaurantTable/memberUse" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> memberUse(@Query("tableId") int tableId, @Query("tableNumber")  String  tableNumber, @Query("memberId") long memberId);

    @GET("restaurantTable/memberUseCancel" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> memberUseCancel(@Query("tableId") int tableId, @Query("tableNumber")  String  tableNumber, @Query("memberId") long memberId);

    @GET("coupon/queryCoupon" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> queryCoupon(@Query("tableId") int tableId,@Query("memberId") Long memberId, @Query("couponMemberId")  long  couponMemberId,@Query("couponNo")  String  couponNo,@Query("restaurantId")  int  restaurantId);

    @Headers({"Domain-Name: ricepon_member"})
    @GET("member/getMemberWalletList" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Single<BaseResult> getMemberWalletList(@Query("brandId") int brandId, @Query("memberId")  long  memberId, @Query("limitType") long limitType, @Query("pageIndex") long pageIndex, @Query("pageSize") long pageSize);
}
