package com.gingersoft.gsa.cloud.common.config.globalconfig.lifecyclesOptioins;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;

import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.gingersoft.gsa.cloud.common.utils.CommonConfiguration;
import com.gingersoft.gsa.cloud.component.ComponentAction;
import com.gingersoft.gsa.cloud.component.ComponentName;
import com.gingersoft.gsa.cloud.database.utils.FoodComboDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.ModifierDaoUtils;

import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.schedulers.Schedulers;


@SuppressLint("NewApi")
public class MyActivityLifecycle implements Application.ActivityLifecycleCallbacks {

    private static final String TAG = MyActivityLifecycle.class.getSimpleName();

    @Override
    public void onActivityCreated(Activity activity, Bundle bundle) {
        LoganManager.w_action(TAG, activity.getClass().getSimpleName() + ": onActivityCreated");
//        EventBus.getDefault().register(activity);
        if (!activity.getIntent().getBooleanExtra("isInitToolbar", false)) {
            //由于加强框架的兼容性,故将 setContentView 放到 onActivityCreated 之后,onActivityStarted 之前执行
            //而 findViewById 必须在 Activity setContentView() 后才有效,所以将以下代码从之前的 onActivityCreated 中移动到 onActivityStarted 中执行
            activity.getIntent().putExtra("isInitToolbar", true);
            //这里全局给Activity设置toolbar和title,你想象力有多丰富,这里就有多强大,以前放到BaseActivity的操作都可以放到这里
//            new ToolbarUtil(activity).setToolbar();
        }
    }

    @Override
    public void onActivityStarted(Activity activity) {
        LoganManager.w_action(TAG, activity.getClass().getSimpleName() + ": onActivityStarted");
    }

    @Override
    public void onActivityResumed(Activity activity) {
        String name = activity.getClass().getSimpleName();
        LoganManager.w_action(TAG, activity.getClass().getSimpleName() + ": onActivityResumed");
        if (name.equals("NewMainActivity")) {
            Observable.create(new ObservableOnSubscribe<Void>() {

                @Override
                public void subscribe(ObservableEmitter<Void> emitter) throws Exception {
                    //每次到首頁都更新食品套餐，細項對應ID備用
                    FoodComboDaoUtils foodComboDaoUtils = new FoodComboDaoUtils(activity);
                    CommonConfiguration.getInstance().saveComboIdConfiguration(foodComboDaoUtils.queryAllCombo());

                    ModifierDaoUtils modifierDaoUtils = new ModifierDaoUtils(activity);
                    CommonConfiguration.getInstance().saveModifierTopIdConfiguration(modifierDaoUtils.queryAllModifier());
                }
            }).subscribeOn(Schedulers.io()).subscribe();

        } else if (name.equals("TableActivity") || name.equals("OrderCenterActivity") || name.equals("OrderDetailActivity")) {
            //初始化堂食,外賣賬單類
            CC.obtainBuilder(ComponentName.COMPONENT_TABLE)
                    .setActionName(ComponentAction.Table.INT_ORDER)
                    .build()
                    .call();
        }
        GsaCloudApplication.getAppContext().setCurrentActivity(activity);
    }

    @Override
    public void onActivityPaused(Activity activity) {
        LoganManager.w_action(TAG, activity.getClass().getSimpleName() + ": onActivityPaused");
    }

    @Override
    public void onActivityStopped(Activity activity) {
        LoganManager.w_action(TAG, activity.getClass().getSimpleName() + ": onActivityStopped");
    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        LoganManager.w_action(TAG, activity.getClass().getSimpleName() + ": onActivitySaveInstanceState");
    }

    @Override
    public void onActivityDestroyed(Activity activity) {
        LoganManager.w_action(TAG, activity.getClass().getSimpleName() + ": onActivityDestroyed");
//        EventBus.getDefault().unregister(activity);
        //横竖屏切换或配置改变时, Activity 会被重新创建实例, 但 Bundle 中的基础数据会被保存下来,移除该数据是为了保证重新创建的实例可以正常工作
        activity.getIntent().removeExtra("isInitToolbar");
    }
}
