package com.gingersoft.gsa.cloud.base.utils;

import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.constans.ExpandConstant;
import com.gingersoft.gsa.cloud.database.bean.ExpandInfo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-05-11
 * 修订历史：2020-05-11
 * 描述：餐廳擴展信息工具類
 */
public class RestaurantExpandInfoUtils {

    public final static String VALUE_INT = "valueInt";
    public final static String VALUE_CHAR = "valueChar";
    public final static String VALUE_DATETIME = "valueDatetime";
    public final static String VALUE_DATETIME2 = "valueDatetime2";
    public final static String REMARK = "remark";

    private static Map<String, Object> map = new HashMap<>();
    private static Map<String, Long> idMaps = new HashMap<>();

    /**
     * 保存常用信息
     *
     * @param expandInfoList
     */
    public static void setCommonExpandInfo(List<ExpandInfo> expandInfoList) {
        for (ExpandInfo expandInfo : expandInfoList) {
            switch (expandInfo.getSettingName()) {
                case ExpandConstant.Rounding:
                    MoneyUtil.rounding = expandInfo.getValueInt();
                    break;
                case ExpandConstant.RoundingDecimal:
                    MoneyUtil.RoundingDecimal = expandInfo.getValueInt();
                    break;
                case ExpandConstant.ItemDecimals:
                    MoneyUtil.ItemDecimals = expandInfo.getValueInt();
                    break;
                case ExpandConstant.MergeSendFood:
                    GsaCloudApplication.androidSetting.setMergeSendFood(expandInfo.getValueInt() == 1);
                    break;
                case ExpandConstant.AutoPrinterPaper:
                    GsaCloudApplication.androidSetting.setAutoPrinterParper(expandInfo.getValueInt() == 1);
                    break;
                case ExpandConstant.PrintMemberInfo:
                case ExpandConstant.PrintPage:
                case ExpandConstant.PrintMergerFood:
                case ExpandConstant.PrintStatisticsAmount:
                case ExpandConstant.PrintFirstOrder:
                case ExpandConstant.FrozenChainAutoOrder:
                    map.put(expandInfo.getSettingName(), expandInfo.getValueInt() == 0);
                    idMaps.put(expandInfo.getSettingName(), expandInfo.getId());
                    break;
                case ExpandConstant.OrderReceivingTimeout:
                case ExpandConstant.DeliveryPrintCount:
                case ExpandConstant.DeliveryClosingPC:
                case ExpandConstant.TableModePrintCount:
                case ExpandConstant.TableModeClosingPC:
                    map.put(expandInfo.getSettingName(), expandInfo.getValueInt());
                    idMaps.put(expandInfo.getSettingName(), expandInfo.getId());
                    break;
            }
        }
    }

    public static <T> T getValue(String name, Object defaultValue) {
        if (map != null && map.containsKey(name)) {
            return (T) map.get(name);
        } else {
            return (T) defaultValue;
        }
    }

    public static void setValue(String name, Object value) {
        map.put(name, value);
    }

    public static Long getId(String name) {
        return idMaps.get(name);
    }
}
