package com.gingersoft.gsa.cloud.main.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.database.bean.ExpandInfo;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.main.R2;
import com.gingersoft.gsa.cloud.main.di.component.DaggerExpandListComponent;
import com.gingersoft.gsa.cloud.main.di.module.ExpandListModule;
import com.gingersoft.gsa.cloud.main.mvp.contract.ExpandListContract;
import com.gingersoft.gsa.cloud.main.mvp.presenter.ExpandListPresenter;
import com.gingersoft.gsa.cloud.main.mvp.ui.adapter.ExpandListAdapter;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.OnClick;

import static com.jess.arms.utils.Preconditions.checkNotNull;


public class ExpandListActivity extends BaseActivity<ExpandListPresenter> implements ExpandListContract.View, View.OnClickListener {
    @BindView(R2.id.rv_expand_list)
    RecyclerView rvExpandList;
    private ExpandListAdapter expandListAdapter;
    @BindView(R2.id.topbar_expand_list)
    QMUITopBar topBar;
    @BindView(R2.id.btn_expand_save)
    QMUIAlphaButton btnSave;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerExpandListComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .expandListModule(new ExpandListModule(this))
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_expand_list; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        mPresenter.getExpandInfoList();
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
        topBar.setBackgroundColor(ContextCompat.getColor(this, R.color.theme_color));
        topBar.addLeftBackImageButton().setOnClickListener(v -> killMyself());
        topBar.setTitle("配置列表");
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    public void loadExpandList(List<ExpandInfo> data) {
        expandListAdapter = new ExpandListAdapter(data);
        rvExpandList.setAdapter(expandListAdapter);
        rvExpandList.setLayoutManager(new LinearLayoutManager(mContext));
    }

    @OnClick(R2.id.btn_expand_save)
    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.btn_expand_save) {
            //保存
            List<ExpandInfo> data = expandListAdapter.getData();
            List<ExpandInfo> updateDate = new ArrayList<>();
            for (int i = 0; i < data.size(); i++) {
                if (data.get(i).getIsUpdate()) {
                    updateDate.add(data.get(i));
                }
            }
            if (updateDate.size() > 0) {
                //調用接口批量修改

            } else {
                killMyself();
            }
        }
    }
}
