package com.gingersoft.gsa.cloud.manager.mvp.model.service;

import com.gingersoft.gsa.cloud.base.Api;
import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.common.bean.FoodBean;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-06
 * 修订历史：2020-01-06
 * 描述：
 */
public interface TableManageService {


    @POST("restaurant/addRestaurantRegion" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addArea(@Body RequestBody requestBody);

    @POST("restaurant/deleteRestaurantRegion" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> deleteArea(@Body RequestBody requestBody);

    @POST("restaurant/updateRestaurantRegion" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateArea(@Body RequestBody requestBody);

    @GET("restaurant/findRestaurantRegion" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> queryArea(@Query("restaurantId") int restaurantId);


    @POST("restaurantTable/addRestaurantTable" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addTable(@Body RequestBody requestBody);

    @POST("restaurantTable/deleteRestaurantTable" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> deleteTable(@Body RequestBody requestBody);

    @POST("restaurantTable/updateRestaurantTable" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateTable(@Body RequestBody requestBody);

    @GET("restaurantTable/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> queryTable(@Query("restaurantId") int restaurantId);



    @POST("restaurant/exchangeSort" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> changeAreaSort(@Body RequestBody requestBody);

    @POST("restaurantTable/exchangeSort" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> changeTableSort(@Body RequestBody requestBody);

    @POST("restaurantTable/updateRestaurantTableBatch" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateTableServiceCharge(@Body RequestBody requestBody);

}
