package com.gingersoft.gsa.cloud.base.order.bean;

import com.gingersoft.gsa.cloud.base.common.bean.MemberInfo;
import com.gingersoft.gsa.cloud.base.order.bean.discount.OrderDiscount;
import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * Created by Wyh on 2020/1/17.
 */
@Data
public class OrderBean {
    /**
     * id : 40553
     * orderNo : gs204650350122922
     * status : 0
     * totalAmount : 141.0
     * totalPoints : 0.0
     * createTime : Jan 14, 2020 7:49:50 PM
     * orderDetails : [{"id":1621502,"productName":"胡椒排骨涼瓜煲","productId":"4257","price":58,"lunchboxPrice":0,"number":1,"createTime":"Jan 14, 2020 8:00:11 PM","status":0},{"id":1621503,"productName":"海南雞(例牌)","productId":"4258","price":83,"lunchboxPrice":0,"number":1,"createTime":"Jan 14, 2020 8:00:11 PM","status":0}]
     */

    private long id = -1;
    private String orderNo;
    private int status;
    private int person;
    private double totalAmount;
    private double totalPoints;
    /**
     * 生成訂單時間
     */
    private String createTime;

    private MemberInfo memberInfo;
    private List<OrderDiscount.Respose> discountDetails;
    private List<OrderDetailsBean> orderDetails;

    public OrderBean() {
    }

    public OrderBean(OrderBean orderBean) {
        this.id = orderBean.id;
        this.status = orderBean.status;
        this.orderNo = orderBean.orderNo;
        this.person = orderBean.person;
        this.memberInfo = orderBean.memberInfo;
        this.discountDetails = orderBean.discountDetails;
        this.createTime = orderBean.createTime;
    }

    @Data
    public static class OrderDetailsBean implements Serializable {
        /**
         * id : 1621502
         * orderId : 47039
         * parentId : 1639956
         * productName : 胡椒排骨涼瓜煲
         * productId : 4257
         * price : 58.0
         * lunchboxPrice : 0.0
         * number : 1
         * createTime : Jan 14, 2020 8:00:11 PM
         * status : 0
         */
        private Long id;
        private String productName;
        private long productId;
        //單價
        private double price;
        private double lunchboxPrice;
        private int number;
        private String createTime;
        private int status;

        private byte type;
        private long parentId;
        private long orderId;
        /**
         * 打印設定, 用逗號分隔, *=切紙
         */
        private String printSetIng;
        /**
         * 廚房單打印主項
         */
        private long ktPrintMainItem;
        /**
         * 是否参与折扣#0:不參與;1:參與;
         */
        private long ablediscount;
        /**折扣ID*/
        private Long discountId;
        /**折扣實體*/
        private RestaurantDiscountVO restaurantDiscountVO;
        /**
         * 是否参与折扣#0:不參與;1:參與;
         **/
        private byte scAble = 1;


        /**
         * 額外食品加分
         */
        private double pointsAdd;
        /**
         * 換購食品所需積分
         */
        private double pointsRedeem;

        /**
         * 0=系統顏色, 1=黑色, 2=紅色
         */
        private long printFont;
        /**
         * 當金額=0時, 是否打印在帳單上
         */
        private long printToBill;
        /**
         * 0食品清单打印 账单打印//1食品清单不打印 账单不打印//2食品清单打印 账单不打印//3食品清单不打印 账单打印
         */
        private long printTo;
        /**
         * 是否打印价格
         */
        private long ktShowPrice;
        /**
         * 自定義字段
         */
        /**
         * 商品父級ID
         */
        private long topId;
        private long memberId;


        public OrderDetailsBean() {
        }

        @Override
        public String toString() {
            return "OrderDetailsBean{" +
                    "id=" + id +
                    ", productName='" + productName + '\'' +
                    ", productId=" + productId +
                    ", price=" + price +
                    ", lunchboxPrice=" + lunchboxPrice +
                    ", number=" + number +
                    ", createTime='" + createTime + '\'' +
                    ", status=" + status +
                    ", type=" + type +
                    ", parentId=" + parentId +
                    ", orderId=" + orderId +
                    ", printSetIng='" + printSetIng + '\'' +
                    ", ktPrintMainItem=" + ktPrintMainItem +
                    ", ablediscount=" + ablediscount +
                    ", discountId=" + discountId +
                    ", restaurantDiscountVO=" + restaurantDiscountVO +
                    ", scAble=" + scAble +
                    ", pointsAdd=" + pointsAdd +
                    ", pointsRedeem=" + pointsRedeem +
                    ", printFont=" + printFont +
                    ", printToBill=" + printToBill +
                    ", printTo=" + printTo +
                    ", ktShowPrice=" + ktShowPrice +
                    ", topId=" + topId +
                    ", memberId=" + memberId +
                    '}';
        }

        @Data
        public static class RestaurantDiscountVO implements Serializable{
            private long id;
            private int type;
            private float discountValue;
            private String remark;
            private double discountAmount;

        }
    }

//    public static List<OrderDetailsBean> transOrderDetails(List<Food> foods) {
//        List<OrderDetailsBean> orderDetailsBeans = new ArrayList<>();
//        for (Food food : foods) {
//            OrderDetailsBean orderDetailsBean = new OrderDetailsBean(food.getFoodName(), food.getParentId()+ "", food.getPrice(), food.getLunchboxPrice(), food.getNumber(), food.getOrderId());
//            orderDetailsBeans.add(orderDetailsBean);
//        }
//        return orderDetailsBeans;
//    }


}
