package com.joe.print.mvp.ui.activity;

import android.os.Bundle;
import android.util.Log;
import android.widget.EditText;

import androidx.appcompat.app.AppCompatActivity;

import com.epson.epos2.printer.Printer;
import com.epson.epos2.printer.PrinterStatusInfo;
import com.epson.epos2.printer.ReceiveListener;
import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication;
import com.gingersoft.gsa.cloud.base.utils.okhttpUtils.OkHttp3Utils;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.base.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.print.PrintExecutor;
import com.gingersoft.gsa.cloud.print.PrintSocketHolder;
import com.joe.print.R;
import com.joe.print.mvp.print.common.PrinterFinderCallback;
import com.joe.print.mvp.print.common.SendCallback;
import com.joe.print.mvp.print.common.SendResultCode;
import com.joe.print.mvp.print.usb.UsbPrinter;
import com.joe.print.mvp.print.usb.UsbPrinterFinder;

import java.util.List;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

public class PrintTestActivity extends AppCompatActivity implements PrintSocketHolder.OnStateChangedListener, PrintExecutor.OnPrintResultListener, ReceiveListener {

    private int lineLength = 42;//一行42個

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_print_test);
        EditText ed_ip = findViewById(R.id.ed_ip);
        UsbPrinterFinder printerFinder = new UsbPrinterFinder(this, printerFinderCallback);
        printerFinder.startFinder();

        findViewById(R.id.btn_test).setOnClickListener(view -> {
            //打印測試
            String stringBuilder = "<html><body>" +
                    getPLable(GsaCloudApplication.getBrandName()) +
                    getPLable(GsaCloudApplication.getRestaurantName()) +
                    getLineLable() +
                    getPLable("餐檯：" + "111") +
                    getPLable("人數：23") +
                    getPLable("123456789123456789123456789123456789123456789") +
                    getPLable("日期：" + TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT)) +
                    getLineLable() +
//                    getPLable(getDiv("牛油燒翠玉瓜", 0)) +
                    "</body></html>";
            OkHttp3Utils.get("http://localhost:8080/pos?transact ionType=PRINT&isExternal=false&apiVersion=21&printData=" + stringBuilder).subscribe(new Observer<String>() {
                @Override
                public void onSubscribe(Disposable d) {

                }

                @Override
                public void onNext(String s) {
                    Log.e("eee", "打印內容：" + s);
                }

                @Override
                public void onError(Throwable e) {

                }

                @Override
                public void onComplete() {

                }
            });
        });
    }



//    private String getDiv(String foodName, String foodNum, String price) {
//
//    }

    private String getLineLable() {
        return "<br/>";
    }

    private String getPLable(String content) {
        return "<p>" + content + "</p>";
    }

    @Override
    public void onResult(int errorCode, PrinterDeviceBean printerDeviceBean) {
        if (errorCode == 0) {
            ToastUtils.show(PrintTestActivity.this, "打印失败");
        }
    }

    @Override
    public void onStateChanged(int state, PrinterDeviceBean printerDeviceBean) {

    }


    private String TAG = "eee";

    private PrinterFinderCallback<UsbPrinter> printerFinderCallback = new PrinterFinderCallback<UsbPrinter>() {

        @Override
        public void onStart() {
            Log.d(TAG, "startFind print");
        }

        @Override
        public void onFound(UsbPrinter usbPrinter) {
            //listAdapter.addData(usbPrinter);
            ToastUtils.show(PrintTestActivity.this, "onFound deviceName = " + usbPrinter.getPrinterName());
            Log.d(TAG, "onFound deviceName = " + usbPrinter.getPrinterName());
        }

        @Override
        public void onFinished(List<UsbPrinter> printers) {
            ToastUtils.show(PrintTestActivity.this, "printCount = " + printers.size());
            Log.d(TAG, "printCount = " + printers.size());
//            listAdapter.replaceDatas(usbPrinters);
        }
    };

    private SendCallback sendCallback = (code, printId) -> {
        String msg = "";
        if (code == SendResultCode.SEND_SUCCESS) {
            Log.d(TAG, "打印成功");
        } else if (code == SendResultCode.SEND_FAILED) {
            Log.d(TAG, "打印失敗");
        }
    };

    @Override
    public void onPtrReceive(Printer printer, int i, PrinterStatusInfo printerStatusInfo, String s) {
        if (i == 0) {
            ToastUtils.show(PrintTestActivity.this, "打印成功");
        } else {
            ToastUtils.show(PrintTestActivity.this, "打印失败");
        }
    }
}
