package com.gingersoft.gsa.cloud.bean.mvp.model.discount;

import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.database.bean.Discount;

import lombok.Getter;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-19
 * 修订历史：2020-09-19
 * 描述: 整單折扣{@link Discount}
 */
@Getter
public class NomalDiscount extends MultyDiscount{

    private Discount discount;
    /**
     * 本次折扣金额
     */
    private Double discountMoney;
    
    public NomalDiscount(MultyDiscount nextMultyDiscount,Discount discount) {
        super(nextMultyDiscount);
        this.discount = discount;
    }

    @Override
    public double calculate(double money) {
        if(discount != null){
            discountMoney = calculationDiscount(discount, money);
            money = MoneyUtil.sum(money,discountMoney);
        }

        return super.calculate(money);
    }

    /**
     * 計算整单折扣金額
     *
     * @param discount
     * @param sourceMoney
     * @return
     */
    public static double calculationDiscount(Discount discount, double sourceMoney) {
        double discountMoney;
        if (discount.getType() == 0) {
            //金額折扣
            discountMoney = discount.getAmount();
        } else {
            //百分比折扣
            discountMoney = MoneyUtil.divide(MoneyUtil.multiply(sourceMoney, discount.getDiscount_value()), 100).doubleValue();
        }
        if (sourceMoney < discountMoney) {
            //折扣金額不能超出總額
            discountMoney = sourceMoney;
        }
        return -MoneyUtil.get_ItemDecimals_money(Math.abs(discountMoney));
    }
}
